/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.client.jei.JEIConstants;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class EnchantingApparatusRecipeCategory
implements IRecipeCategory<EnchantingApparatusRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ars_nouveau", "apparatus");
    IGuiHelper helper;
    public IDrawable background;
    public IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public EnchantingApparatusRecipeCategory(final IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createBlankDrawable(114, 108);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(JEIConstants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return EnchantingApparatusRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("ars_nouveau.enchanting_apparatus");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(EnchantingApparatusRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Font renderer = Minecraft.m_91087_().f_91062_;
        if (recipe.consumesSource()) {
            renderer.m_92889_(matrixStack, (Component)new TranslatableComponent("ars_nouveau.source", new Object[]{recipe.sourceCost}), 0.0f, 100.0f, 10);
        }
    }

    public void setIngredients(EnchantingApparatusRecipe o, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> itemStacks = new ArrayList<List<ItemStack>>();
        itemStacks.add(Arrays.asList(o.reagent.m_43908_()));
        for (Ingredient i : o.pedestalItems) {
            itemStacks.add(Arrays.asList(i.m_43908_()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, itemStacks);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)o.result);
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnchantingApparatusRecipe apparatusRecipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 48, 45);
        recipeLayout.getItemStacks().set(0, Arrays.asList(apparatusRecipe.reagent.m_43908_()));
        int index = 1;
        List pedestalList = ingredients.getInputs(VanillaTypes.ITEM);
        if (pedestalList.size() > 0) {
            pedestalList = pedestalList.subList(1, pedestalList.size());
            double angleBetweenEach = 360.0 / (double)pedestalList.size();
            Vec2 point = new Vec2(48.0f, 13.0f);
            Vec2 center = new Vec2(48.0f, 45.0f);
            for (List o : pedestalList) {
                recipeLayout.getItemStacks().init(index, true, (int)point.f_82470_, (int)point.f_82471_);
                recipeLayout.getItemStacks().set(index, o);
                ++index;
                point = EnchantingApparatusRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
            }
        }
        recipeLayout.getItemStacks().init(index, false, 86, 10);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.f_82470_ - about.f_82470_) - Math.sin(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82470_;
        double newY = Math.sin(rad) * (double)(in.f_82470_ - about.f_82470_) + Math.cos(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82471_;
        return new Vec2((float)newX, (float)newY);
    }
}

