/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.JEIConstants;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class GlyphRecipeCategory
implements IRecipeCategory<GlyphRecipe> {
    public IDrawable background;
    public IDrawable icon;
    IGuiHelper helper;
    public static final ResourceLocation UID = new ResourceLocation("ars_nouveau", "glyph_recipe");
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public GlyphRecipeCategory(final IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createBlankDrawable(114, 108);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)BlockRegistry.SCRIBES_BLOCK));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(JEIConstants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends GlyphRecipe> getRecipeClass() {
        return GlyphRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("block.ars_nouveau.scribes_table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(GlyphRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Font renderer = Minecraft.m_91087_().f_91062_;
        renderer.m_92889_(matrixStack, (Component)new TranslatableComponent("ars_nouveau.exp", new Object[]{ScribesTile.getLevelsFromExp(recipe.exp)}), 0.0f, 100.0f, 10);
    }

    public void setIngredients(GlyphRecipe o, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> itemStacks = new ArrayList<List<ItemStack>>();
        for (Ingredient i : o.inputs) {
            itemStacks.add(Arrays.asList(i.m_43908_()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, itemStacks);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)o.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, GlyphRecipe apparatusRecipe, IIngredients ingredients) {
        int index = 0;
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
        Vec2 point = new Vec2(48.0f, 13.0f);
        Vec2 center = new Vec2(48.0f, 45.0f);
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, (int)point.f_82470_, (int)point.f_82471_);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            point = EnchantingApparatusRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        recipeLayout.getItemStacks().init(index, false, 86, 10);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

