/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AlchemicalSourcelinkTile
extends SourcelinkTile {
    public AlchemicalSourcelinkTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.ALCHEMICAL_TILE, pos, state);
    }

    @Override
    public int getMaxSource() {
        return 20000;
    }

    @Override
    public int getTransferRate() {
        return 10000;
    }

    @Override
    public void tick() {
        BlockPos potionPos;
        super.tick();
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 0L && (potionPos = AlchemicalSourcelinkTile.findNearbyPotion(this.f_58857_, this.f_58858_)) != null) {
            PotionJarTile tile = (PotionJarTile)this.f_58857_.m_7702_(potionPos);
            int mana = 75;
            HashSet<MobEffect> effectTypes = new HashSet<MobEffect>();
            for (MobEffectInstance e : tile.getFullEffects()) {
                mana += e.m_19557_() / 50;
                mana += e.m_19564_() * 250;
                mana += 150;
                effectTypes.add(e.m_19544_());
            }
            if (effectTypes.size() > 1) {
                mana = (int)((double)mana * (1.5 * (double)(effectTypes.size() - 1)));
            }
            this.addSource(mana);
            tile.addAmount(-100);
        }
    }

    @Nullable
    public static BlockPos findNearbyPotion(Level level, BlockPos worldPosition) {
        for (BlockPos p : BlockPos.m_121925_((BlockPos)worldPosition.m_6625_(1), (int)1, (int)1, (int)1)) {
            PotionJarTile tile;
            BlockEntity blockEntity = level.m_7702_(p);
            if (!(blockEntity instanceof PotionJarTile) || (tile = (PotionJarTile)blockEntity).getCurrentFill() < 100) continue;
            return p;
        }
        return null;
    }
}

