/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RuneTile
extends AnimatedTile
implements IPickupResponder,
IAnimatable,
ITickable {
    public Spell spell = Spell.EMPTY;
    public boolean isTemporary = false;
    public boolean isCharged = true;
    public int ticksUntilCharge = 0;
    public UUID uuid;
    public ParticleColor color = ParticleUtil.defaultParticleColor();
    public Entity touchedEntity;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public RuneTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.RUNE_TILE, pos, state);
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
    }

    public void castSpell(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!this.isCharged || this.spell.isEmpty() || !(this.f_58857_ instanceof ServerLevel) || !(this.spell.recipe.get(0) instanceof MethodTouch)) {
            return;
        }
        try {
            FakePlayer playerEntity = this.uuid != null ? this.f_58857_.m_46003_(this.uuid) : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_));
            playerEntity = playerEntity == null ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_)) : playerEntity;
            EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.spell, (LivingEntity)playerEntity).withCastingTile(this).withType(SpellContext.CasterType.RUNE).withColors(this.color.toWrapper()));
            resolver.onCastOnEntity(ItemStack.f_41583_, (LivingEntity)playerEntity, entity, InteractionHand.MAIN_HAND);
            if (this.isTemporary) {
                this.f_58857_.m_46961_(this.f_58858_, false);
                return;
            }
            this.isCharged = false;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61122_((Property)RuneBlock.POWERED));
            this.ticksUntilCharge = 40;
        }
        catch (Exception e) {
            PortUtil.sendMessage(entity, (Component)new TranslatableComponent("ars_nouveau.rune.error"));
            e.printStackTrace();
            this.f_58857_.m_46961_(this.f_58858_, false);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("spell", this.spell.serialize());
        tag.m_128379_("charged", this.isCharged);
        tag.m_128379_("temp", this.isTemporary);
        tag.m_128405_("cooldown", this.ticksUntilCharge);
        if (this.uuid != null) {
            tag.m_128362_("uuid", this.uuid);
        }
        if (this.color != null) {
            tag.m_128359_("color", this.color.toWrapper().serialize());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.spell = Spell.deserialize(tag.m_128461_("spell"));
        this.isCharged = tag.m_128471_("charged");
        this.isTemporary = tag.m_128471_("temp");
        this.ticksUntilCharge = tag.m_128451_("cooldown");
        if (tag.m_128441_("uuid")) {
            this.uuid = tag.m_128342_("uuid");
        }
        this.color = ParticleColor.IntWrapper.deserialize(tag.m_128461_("color")).toParticleColor();
        super.m_142466_(tag);
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.ticksUntilCharge > 0) {
            --this.ticksUntilCharge;
            return;
        }
        if (this.isCharged) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isTemporary) {
            this.f_58857_.m_46961_(this.f_58858_, false);
        }
        if (!this.f_58857_.f_46443_) {
            BlockPos fromPos = SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 10, 100);
            if (fromPos != null) {
                this.isCharged = true;
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61122_((Property)RuneBlock.POWERED));
            } else {
                this.ticksUntilCharge = 60;
            }
        }
    }

    @Override
    public List<IItemHandler> getInventory() {
        return BlockUtil.getAdjacentInventories(this.f_58857_, this.f_58858_);
    }

    @Override
    @Nonnull
    public ItemStack onPickup(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.f_58857_, this.f_58858_, stack);
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

