/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SummoningCrystalTile
extends AbstractSourceMachine
implements IAnimatable,
ITickable {
    public boolean isOff;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);

    public SummoningCrystalTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.SUMMONING_CRYSTAL_TILE, pos, state);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "rotate_controller", 0.0f, this::idlePredicate));
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("summoning_crystal", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    @Override
    public int getTransferRate() {
        return 0;
    }

    public ItemStack insertItem(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.f_58857_, this.f_58858_, stack);
    }

    public boolean enoughMana(int manaCost) {
        return SourceUtil.hasSourceNearby(this.f_58858_, this.f_58857_, 7, manaCost);
    }

    public boolean removeManaAround(int manaCost) {
        return SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 7, manaCost) != null;
    }

    @Override
    public void tick() {
        Random rand = this.f_58857_.m_5822_();
        if (this.f_58857_.f_46443_ && rand.nextInt(6) == 0) {
            for (int i = 0; i < 10; ++i) {
                this.f_58857_.m_7106_(ParticleSparkleData.createData(ParticleUtil.defaultParticleColor(), 0.05f, 60), (double)this.f_58858_.m_123341_() + ParticleUtil.inRange(-0.5, 0.5) + 0.5, (double)this.f_58858_.m_123342_() + ParticleUtil.inRange(-1.0, 1.0), (double)this.f_58858_.m_123343_() + ParticleUtil.inRange(-0.5, 0.5) + 0.5, ParticleUtil.inRange(-0.03, 0.03), ParticleUtil.inRange(0.01, 0.5), ParticleUtil.inRange(-0.03, 0.03));
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isOff = tag.m_128471_("is_off");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128379_("is_off", this.isOff);
    }
}

