/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GlyphRecipe
implements Recipe<ScribesTile> {
    public static final String RECIPE_ID = "glyph";
    public ItemStack output;
    public List<Ingredient> inputs;
    public ResourceLocation id;
    public int exp;

    public GlyphRecipe(ResourceLocation id, ItemStack output, List<Ingredient> inputs, int exp) {
        this.id = id;
        this.output = output;
        this.inputs = inputs;
        this.exp = exp;
    }

    public GlyphRecipe withIngredient(Ingredient i) {
        this.inputs.add(i);
        return this;
    }

    public GlyphRecipe withIngredient(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.withIngredient(ingredient);
        }
        return this;
    }

    public GlyphRecipe withIngredient(Tag.Named<Item> tag, int count) {
        for (int i = 0; i < count; ++i) {
            this.withIngredient(Ingredient.m_43911_(tag));
        }
        return this;
    }

    public GlyphRecipe withItem(ItemLike i) {
        this.inputs.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{i}));
        return this;
    }

    public GlyphRecipe withItem(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.withItem(item);
        }
        return this;
    }

    public GlyphRecipe withStack(ItemStack i) {
        this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{i}));
        return this;
    }

    public GlyphRecipe withStack(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            this.withStack(stack);
        }
        return this;
    }

    public AbstractSpellPart getSpellPart() {
        return ((Glyph)this.output.m_41720_()).spellPart;
    }

    public boolean matches(ScribesTile pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(ScribesTile pContainer) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeRegistry.GLYPH_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return RecipeRegistry.GLYPH_TYPE;
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:glyph");
        jsonobject.addProperty("count", (Number)this.output.m_41613_());
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient i : this.inputs) {
            JsonObject object = new JsonObject();
            object.add("item", i.m_43942_());
            pedestalArr.add((JsonElement)object);
        }
        jsonobject.add("inputItems", (JsonElement)pedestalArr);
        jsonobject.addProperty("exp", (Number)this.exp);
        jsonobject.addProperty("output", this.output.m_41720_().getRegistryName().toString());
        return jsonobject;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<GlyphRecipe> {
        public GlyphRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Item output = GsonHelper.m_13909_((JsonObject)json, (String)"output");
            int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            ItemStack outputStack = new ItemStack((ItemLike)output, count);
            int levels = GsonHelper.m_13927_((JsonObject)json, (String)"exp");
            JsonArray inputItems = GsonHelper.m_13933_((JsonObject)json, (String)"inputItems");
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (JsonElement e : inputItems) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient input = null;
                input = GsonHelper.m_13885_((JsonObject)obj, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)obj, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"item"));
                stacks.add(input);
            }
            return new GlyphRecipe(recipeId, outputStack, stacks, levels);
        }

        public void toNetwork(FriendlyByteBuf buf, GlyphRecipe recipe) {
            buf.writeInt(recipe.inputs.size());
            for (Ingredient i : recipe.inputs) {
                i.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
            buf.writeInt(recipe.exp);
        }

        @Nullable
        public GlyphRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new GlyphRecipe(recipeId, buffer.m_130267_(), stacks, buffer.readInt());
        }
    }
}

