/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.ReactiveEnchantmentRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.SpellWriteRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.Recipes;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApparatusRecipeProvider
implements DataProvider {
    protected final DataGenerator generator;
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public List<EnchantingApparatusRecipe> recipes = new ArrayList<EnchantingApparatusRecipe>();

    public ApparatusRecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addEntries();
        Path output = this.generator.m_123916_();
        for (IEnchantingRecipe iEnchantingRecipe : this.recipes) {
            if (!(iEnchantingRecipe instanceof EnchantingApparatusRecipe)) continue;
            EnchantingApparatusRecipe recipe = (EnchantingApparatusRecipe)iEnchantingRecipe;
            System.out.println(iEnchantingRecipe);
            Path path = ApparatusRecipeProvider.getRecipePath(output, recipe.m_6423_().m_135815_());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)recipe.asRecipe(), (Path)path);
        }
    }

    public ApparatusRecipeBuilder builder() {
        return ApparatusRecipeBuilder.builder();
    }

    public void addEntries() {
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.BELT_OF_LEVITATION).withReagent((ItemLike)ItemsRegistry.MUNDANE_BELT).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD)).withPedestalItem(3, (ItemLike)Items.f_42402_).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.JAR_OF_LIGHT).withReagent((ItemLike)Items.f_42590_).withPedestalItem(4, (ItemLike)Items.f_42054_).withPedestalItem(2, (ItemLike)Items.f_42105_).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GLASS)).build());
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.MAGE_BLOOM_CROP).withReagent(Ingredient.m_43911_((Tag)Tags.Items.SEEDS)).withPedestalItem(4, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.RING_OF_LESSER_DISCOUNT).withReagent((ItemLike)ItemsRegistry.RING_OF_POTENTIAL).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.ENDER_PEARLS)).withPedestalItem(2, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.RING_OF_GREATER_DISCOUNT).withReagent((ItemLike)ItemsRegistry.RING_OF_LESSER_DISCOUNT).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).withPedestalItem(2, Recipes.SOURCE_GEM).build());
        this.addRecipe(new EnchantingApparatusRecipe(new ItemStack((ItemLike)ItemsRegistry.BELT_OF_UNSTABLE_GIFTS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.MUNDANE_BELT}), Arrays.asList(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), Ingredient.m_43911_((Tag)Tags.Items.CROPS_NETHER_WART), Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE), Ingredient.m_43911_((Tag)Tags.Items.DUSTS_GLOWSTONE), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_}), Ingredient.m_43911_((Tag)Tags.Items.DUSTS_REDSTONE), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42543_}), Ingredient.m_43911_((Tag)Tags.Items.FEATHERS))));
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.BOOKWYRM_CHARM).withReagent((ItemLike)Items.f_42517_).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.INGOTS_IRON)).withPedestalItem(4, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.STARBUNCLE_CHARM).withReagent((ItemLike)ItemsRegistry.STARBUNCLE_SHARD).withPedestalItem(5, Ingredient.m_43911_((Tag)Tags.Items.NUGGETS_GOLD)).withPedestalItem(3, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.AMULET_OF_MANA_BOOST).withReagent((ItemLike)ItemsRegistry.DULL_TRINKET).withPedestalItem(3, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(5, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.AMULET_OF_MANA_REGEN).withReagent((ItemLike)ItemsRegistry.DULL_TRINKET).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD)).withPedestalItem(4, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.WHIRLISPRIG_CHARM).withReagent((ItemLike)ItemsRegistry.WHIRLISPRIG_SHARDS).withPedestalItem(Recipes.SOURCE_GEM).withPedestalItem((ItemLike)BlockRegistry.MAGE_BLOOM_CROP).withPedestalItem((ItemLike)ItemsRegistry.MAGE_BLOOM).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem((ItemLike)Items.f_42799_).withPedestalItem((ItemLike)Items.f_42800_).withPedestalItem((ItemLike)Items.f_42801_).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.SEEDS_WHEAT)).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.VOID_JAR).withReagent((ItemLike)Items.f_42590_).withPedestalItem((ItemLike)Items.f_42448_).withPedestalItem((ItemLike)Items.f_42446_).withPedestalItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.ENDER_PEARLS)).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.DOMINION_ROD).withReagent((ItemLike)Items.f_42398_).withPedestalItem(2, Recipes.SOURCE_GEM).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD)).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.WIXIE_CHARM).withReagent((ItemLike)ItemsRegistry.WIXIE_SHARD).withPedestalItem(Ingredient.m_43911_((Tag)ItemTags.f_13180_)).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.GEMS_EMERALD)).withPedestalItem((ItemLike)Items.f_41960_).withPedestalItem((ItemLike)Items.f_42543_).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.WAND).withReagent(Recipes.ARCHWOOD_LOG).withPedestalItem(4, Recipes.SOURCE_GEM).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD)).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.SPELL_BOW).withReagent((ItemLike)Items.f_42411_).withPedestalItem(Recipes.SOURCE_GEM_BLOCK).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)ItemsRegistry.AMPLIFY_ARROW, 32)).withReagent(Ingredient.m_43911_((Tag)ItemTags.f_13161_)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)ItemsRegistry.SPLIT_ARROW, 32)).withReagent(Ingredient.m_43911_((Tag)ItemTags.f_13161_)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, (ItemLike)ItemsRegistry.WILDEN_HORN).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)ItemsRegistry.PIERCE_ARROW, 32)).withReagent(Ingredient.m_43911_((Tag)ItemTags.f_13161_)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_SPIKE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)ItemsRegistry.POTION_FLASK)).withReagent(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_})).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(Recipes.SOURCE_GEM_BLOCK).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_GOLD)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)ItemsRegistry.POTION_FLASK_EXTEND_TIME)).withReagent(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.POTION_FLASK})).withPedestalItem(8, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)ItemsRegistry.POTION_FLASK_AMPLIFY)).withReagent(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.POTION_FLASK})).withPedestalItem(8, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).build());
        this.addRecipe(this.builder().withResult(new ItemStack((ItemLike)BlockRegistry.POTION_MELDER)).withReagent(Ingredient.m_43929_((ItemLike[])new ItemLike[]{BlockRegistry.POTION_JAR})).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).build());
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43911_((Tag)ItemTags.f_13156_)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44971_, 1, 5000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_})).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).buildEnchantmentRecipe(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 2, 6000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_EMERALD)).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.ENDER_PEARLS)).withPedestalItem((ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).buildEnchantmentRecipe(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44979_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44979_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44979_, 3, 500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44979_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44979_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_IRON)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(0, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44968_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_IRON)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44968_, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.OBSIDIAN)).buildEnchantmentRecipe(Enchantments.f_44968_, 3, 6000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_GOLD)).buildEnchantmentRecipe(Enchantments.f_44968_, 4, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44973_, 1, 3000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42695_})).buildEnchantmentRecipe(Enchantments.f_44973_, 2, 6000));
        this.addRecipe(this.builder().withPedestalItem(4, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(3, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42716_})).buildEnchantmentRecipe(Enchantments.f_44973_, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_})).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42385_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44984_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42432_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44984_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42432_})).withPedestalItem(3, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.OBSIDIAN)).buildEnchantmentRecipe(Enchantments.f_44984_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42390_})).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42384_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.OBSIDIAN)).buildEnchantmentRecipe(Enchantments.f_44984_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42390_})).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42389_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44984_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.SLIMEBALLS)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44967_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.SLIMEBALLS)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44967_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.SLIMEBALLS)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44967_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(4, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44967_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44981_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44981_, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44966_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44966_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(3, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.f_44966_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.f_44966_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(3, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.f_44966_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.f_44990_, 1, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(6, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44987_, 1, 6000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44987_, 2, 8000));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_DIAMOND)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44987_, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(7, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_DIAMOND)).buildEnchantmentRecipe(Enchantments.f_44952_, 1, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44980_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44980_, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_EMERALD)).withPedestalItem(6, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44982_, 1, 6000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_EMERALD)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44982_, 2, 8000));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_EMERALD)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44982_, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(5, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44959_, 1, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44961_, 1, 2500));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44961_, 2, 5000));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44961_, 3, 7500));
        this.addRecipe(this.builder().withPedestalItem(4, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44961_, 4, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44988_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44988_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44988_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44988_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(5, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44988_, 5, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44969_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44969_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(3, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44969_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44969_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(3, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44969_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44965_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44965_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(3, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44965_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44965_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(3, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_DIAMOND)).buildEnchantmentRecipe(Enchantments.f_44965_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44989_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44989_, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44960_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44960_, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44960_, 3, 6000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44970_, 1, 3000));
        this.addRecipe(this.builder().withPedestalItem(4, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(4, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44970_, 2, 6000));
        this.addRecipe(this.builder().withPedestalItem(6, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.f_44970_, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44977_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44977_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44977_, 3, 500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44977_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44977_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_EMERALD)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44985_, 1, 9000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42262_})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44978_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42262_})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44978_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42262_})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44978_, 3, 500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42262_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44978_, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42262_})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44978_, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44983_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44983_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(3, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44983_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_SPIKE})).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44972_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_SPIKE})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44972_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_SPIKE})).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(3, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44972_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44986_, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44986_, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(3, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.f_44986_, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withPedestalItem(4, Recipes.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(4, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(1, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(4, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withPedestalItem(2, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withPedestalItem(3, (ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, 3, 5000));
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.ENCHANTERS_SWORD).withReagent((ItemLike)Items.f_42388_).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.ENCHANTERS_SHIELD).withReagent((ItemLike)Items.f_42740_).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(2, Recipes.SOURCE_GEM_BLOCK).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.DRYGMY_CHARM).withReagent((ItemLike)ItemsRegistry.DRYGMY_SHARD).withPedestalItem(Ingredient.m_43911_((Tag)ItemTags.f_13156_)).withPedestalItem((ItemLike)Items.f_42405_).withPedestalItem((ItemLike)Items.f_42410_).withPedestalItem((ItemLike)Items.f_42619_).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.SEEDS)).withPedestalItem(3, Recipes.SOURCE_GEM).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.SUMMONING_FOCUS).withReagent(Recipes.SOURCE_GEM_BLOCK).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_HORN).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_SPIKE).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_WING).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_TRIBUTE).withPedestalItem(Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD)).build());
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.RELAY_SPLITTER).withReagent((ItemLike)BlockRegistry.RELAY).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_QUARTZ)).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_LAPIS)).build());
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.RELAY_WARP).withReagent((ItemLike)BlockRegistry.RELAY).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.ENDER_PEARLS)).withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42731_})).build());
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.RELAY_DEPOSIT).withReagent((ItemLike)BlockRegistry.RELAY).withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42155_})).build());
        this.addRecipe(this.builder().withResult((ItemLike)ItemsRegistry.ENCHANTERS_MIRROR).withReagent(Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.GLASS)).withPedestalItem(2, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(2, Recipes.ARCHWOOD_LOG).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD)).build());
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.TIMER_SPELL_TURRET).withReagent((ItemLike)BlockRegistry.BASIC_SPELL_TURRET).withPedestalItem((ItemLike)Items.f_42524_).build());
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.ENCHANTED_SPELL_TURRET).withReagent((ItemLike)BlockRegistry.BASIC_SPELL_TURRET).withPedestalItem(Recipes.SOURCE_GEM_BLOCK).withPedestalItem(2, Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE)).build());
        ArrayList<Ingredient> reactiveIngredients = new ArrayList<Ingredient>();
        reactiveIngredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.SPELL_PARCHMENT}));
        reactiveIngredients.add(Ingredient.m_43911_((Tag)Tags.Items.STORAGE_BLOCKS_LAPIS));
        reactiveIngredients.add(Ingredient.m_43911_(Recipes.SOURCE_GEM_BLOCK_TAG));
        this.addRecipe(new ReactiveEnchantmentRecipe(reactiveIngredients, 3000));
        ArrayList<Ingredient> spellWriteList = new ArrayList<Ingredient>();
        spellWriteList.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.SPELL_PARCHMENT}));
        this.addRecipe(new SpellWriteRecipe(spellWriteList));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(1, Ingredient.m_43911_((Tag)Tags.Items.ENDER_PEARLS)).withPedestalItem(1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_TRIBUTE})).buildEnchantmentRecipe(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 4, 9000));
        this.addRecipe(this.builder().withResult((ItemLike)BlockRegistry.RELAY_COLLECTOR).withReagent((ItemLike)BlockRegistry.RELAY).withPedestalItem(4, Ingredient.m_43911_((Tag)Tags.Items.CHESTS)).build());
    }

    public void addRecipe(EnchantingApparatusRecipe recipe) {
        this.recipes.add(recipe);
    }

    protected static Path getRecipePath(Path pathIn, Item item) {
        return ApparatusRecipeProvider.getRecipePath(pathIn, item.getRegistryName().m_135815_());
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/recipes/" + str + ".json");
    }

    public String m_6055_() {
        return "Apparatus";
    }
}

