/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TakeItemGoal
extends ExtendedRangeGoal {
    Starbuncle carbuncle;
    BlockPos takePos;
    boolean unreachable;

    public TakeItemGoal(Starbuncle carbuncle) {
        super(25);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.carbuncle = carbuncle;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.takePos = null;
        this.unreachable = false;
        this.startDistance = 0.0;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.takePos = this.carbuncle.getValidTakePos();
        this.unreachable = false;
        if (this.carbuncle.isTamed() && this.takePos != null && this.carbuncle.getHeldStack().m_41619_()) {
            this.startDistance = BlockUtil.distanceFrom(this.carbuncle.f_19825_, this.takePos);
            this.setPath(this.takePos.m_123341_(), this.takePos.m_123342_(), this.takePos.m_123343_(), 1.2);
        }
    }

    public void getItem() {
        Level world = this.carbuncle.f_19853_;
        if (world.m_7702_(this.takePos) == null) {
            return;
        }
        IItemHandler iItemHandler = (IItemHandler)world.m_7702_(this.takePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (iItemHandler == null) {
            return;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            int count;
            if (iItemHandler.getStackInSlot(j).m_41619_() || (count = this.carbuncle.getMaxTake(iItemHandler.getStackInSlot(j))) <= 0) continue;
            this.carbuncle.getValidStorePos(iItemHandler.getStackInSlot(j));
            this.carbuncle.setHeldStack(iItemHandler.extractItem(j, count, false));
            this.carbuncle.f_19853_.m_6263_(null, this.carbuncle.m_20185_(), this.carbuncle.m_20186_(), this.carbuncle.m_20189_(), SoundEvents.f_12019_, this.carbuncle.m_5720_(), 1.0f, 1.0f);
            if (!(world instanceof ServerLevel)) break;
            try {
                OpenChestEvent event = new OpenChestEvent(FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world)), this.takePos, 20);
                event.open();
                EventQueue.getServerInstance().addEvent(event);
            }
            catch (Throwable throwable) {}
            break;
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.carbuncle.getNavigation().tryMoveToBlockPos(new BlockPos(x, y, z), 1.3);
        if (this.carbuncle.getNavigation().m_26570_() != null && !this.carbuncle.getNavigation().m_26570_().m_77403_()) {
            this.unreachable = true;
        }
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.carbuncle.getHeldStack().m_41619_() && this.takePos != null && BlockUtil.distanceFrom(this.carbuncle.m_20182_(), this.takePos) <= 2.0 + this.extendedRange) {
            Level world = this.carbuncle.f_19853_;
            BlockEntity tileEntity = world.m_7702_(this.takePos);
            if (tileEntity == null) {
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                this.getItem();
                return;
            }
        }
        if (this.takePos != null && this.carbuncle.getHeldStack().m_41619_()) {
            this.setPath(this.takePos.m_123341_(), this.takePos.m_123342_(), this.takePos.m_123343_(), 1.3);
        }
    }

    public boolean m_8045_() {
        return !this.unreachable && !this.carbuncle.isStuck && this.carbuncle.getHeldStack() != null && this.carbuncle.getHeldStack().m_41619_() && this.carbuncle.getBackOff() == 0 && this.carbuncle.isTamed() && this.takePos != null;
    }

    @Override
    public boolean m_8036_() {
        return !this.carbuncle.isStuck && this.carbuncle.getHeldStack() != null && this.carbuncle.getHeldStack().m_41619_() && this.carbuncle.getBackOff() == 0 && this.carbuncle.isTamed();
    }
}

