/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class DominionWand
extends ModItem {
    public DominionWand() {
        super("dominion_wand");
    }

    public void m_6883_(ItemStack stack, Level p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        super.m_6883_(stack, p_77663_2_, p_77663_3_, p_77663_4_, p_77663_5_);
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
    }

    public InteractionResult m_6880_(ItemStack doNotUseStack, Player playerEntity, LivingEntity target, InteractionHand hand) {
        if (playerEntity.f_19853_.f_46443_ || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerEntity.m_21120_(hand);
        if (playerEntity.m_6144_() && target instanceof IWandable) {
            ((IWandable)target).onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return InteractionResult.SUCCESS;
        }
        if ((this.getPos(stack) == null || this.getPos(stack).equals((Object)new BlockPos(0, 0, 0))) && this.getEntityID(stack) == -1) {
            this.setEntityID(stack, target.m_142049_());
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.dominion_wand.stored_entity"));
            return InteractionResult.SUCCESS;
        }
        Level world = playerEntity.m_20193_();
        if (this.getPos(stack) != null && world.m_7702_(this.getPos(stack)) instanceof IWandable) {
            ((IWandable)world.m_7702_(this.getPos(stack))).onFinishedConnectionFirst(this.getPos(stack), target, playerEntity);
        }
        if (target instanceof IWandable) {
            ((IWandable)target).onFinishedConnectionLast(this.getPos(stack), target, playerEntity);
            this.clear(stack, playerEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void clear(ItemStack stack, Player playerEntity) {
        this.setPosTag(stack, null);
        this.setEntityID(stack, -1);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return super.m_6225_(context);
        }
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player playerEntity = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (playerEntity.m_6144_() && world.m_7702_(pos) instanceof IWandable) {
            ((IWandable)world.m_7702_(pos)).onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return InteractionResult.CONSUME;
        }
        if (this.getEntityID(stack) == -1 && (this.getPos(stack) == null || this.getPos(stack).equals((Object)new BlockPos(0, 0, 0)))) {
            this.setPosTag(stack, pos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.dominion_wand.position_set"));
            return InteractionResult.SUCCESS;
        }
        if (this.getPos(stack) != null && world.m_7702_(this.getPos(stack)) instanceof IWandable) {
            ((IWandable)world.m_7702_(this.getPos(stack))).onFinishedConnectionFirst(pos, (LivingEntity)world.m_6815_(this.getEntityID(stack)), playerEntity);
        }
        if (world.m_7702_(pos) instanceof IWandable) {
            ((IWandable)world.m_7702_(pos)).onFinishedConnectionLast(this.getPos(stack), (LivingEntity)world.m_6815_(this.getEntityID(stack)), playerEntity);
        }
        if (this.getEntityID(stack) != -1 && world.m_6815_(this.getEntityID(stack)) instanceof IWandable) {
            ((IWandable)world.m_6815_(this.getEntityID(stack))).onFinishedConnectionFirst(pos, null, playerEntity);
        }
        this.clear(stack, playerEntity);
        return super.m_6225_(context);
    }

    public void drawConnection(BlockPos pos1, BlockPos pos2, ServerLevel world) {
        ParticleUtil.beam(pos1, pos2, (Level)world);
    }

    public void setPosTag(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41783_();
        if (pos == null && tag != null && tag.m_128441_("to_x")) {
            tag.m_128473_("to_x");
            tag.m_128473_("to_y");
            tag.m_128473_("to_z");
        } else if (pos != null && tag != null) {
            stack.m_41783_().m_128405_("to_x", pos.m_123341_());
            stack.m_41783_().m_128405_("to_y", pos.m_123342_());
            stack.m_41783_().m_128405_("to_z", pos.m_123343_());
        }
    }

    public void setEntityID(ItemStack stack, int id) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        stack.m_41783_().m_128405_("en_id", id);
    }

    public int getEntityID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("en_id")) {
            return -1;
        }
        return stack.m_41783_().m_128451_("en_id");
    }

    public BlockPos getPos(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        return new BlockPos(tag.m_128451_("to_x"), tag.m_128451_("to_y"), tag.m_128451_("to_z"));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag p_77624_4_) {
        BlockPos pos = this.getPos(stack);
        tooltip.add((Component)(this.getEntityID(stack) == -1 ? new TranslatableComponent("ars_nouveau.dominion_wand.no_entity") : new TranslatableComponent("ars_nouveau.dominion_wand.entity_stored")));
        if (pos == null) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.dominion_wand.no_location"));
            return;
        }
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.dominion_wand.position_stored", new Object[]{DominionWand.getPosString(pos)}));
    }

    public static String getPosString(BlockPos pos) {
        return new TranslatableComponent("ars_nouveau.position", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).getString();
    }
}

