/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EffectSmelt
extends AbstractEffect {
    public static EffectSmelt INSTANCE = new EffectSmelt();

    private EffectSmelt() {
        super("smelt", "Smelt");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        int aoeBuff = spellStats.getBuffCount(AugmentAOE.INSTANCE);
        int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
        int maxItemSmelt = 3 + 4 * aoeBuff + 4 * pierceBuff;
        List itemEntities = world.m_45976_(ItemEntity.class, new AABB(rayTraceResult.m_82443_().m_142538_()).m_82400_((double)aoeBuff + 1.0));
        this.smeltItems(world, itemEntities, maxItemSmelt);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        int aoeBuff = spellStats.getBuffCount(AugmentAOE.INSTANCE);
        int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
        int maxItemSmelt = 3 + 4 * aoeBuff + 4 * pierceBuff;
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.m_82425_(), rayTraceResult, spellStats);
        List itemEntities = world.m_45976_(ItemEntity.class, new AABB(rayTraceResult.m_82425_()).m_82400_((double)aoeBuff + 1.0));
        this.smeltItems(world, itemEntities, maxItemSmelt);
        for (BlockPos pos : posList) {
            if (!this.canBlockBeHarvested(spellStats, world, pos)) continue;
            this.smeltBlock(world, pos, shooter);
        }
    }

    public void smeltBlock(Level world, BlockPos pos, LivingEntity shooter) {
        ItemStack itemstack;
        BlockState state = world.m_8055_(pos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, pos)) {
            return;
        }
        Optional optional = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1)}), world);
        if (optional.isPresent() && !(itemstack = ((SmeltingRecipe)optional.get()).m_8043_()).m_41619_()) {
            if (itemstack.m_41720_() instanceof BlockItem) {
                world.m_46597_(pos, ((BlockItem)itemstack.m_41720_()).m_40614_().m_49966_());
            } else {
                BlockUtil.destroyBlockSafely(world, pos, false, shooter);
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemstack.m_41777_()));
                BlockUtil.safelyUpdateState(world, pos);
            }
        }
    }

    public void smeltItems(Level world, List<ItemEntity> itemEntities, int maxItemSmelt) {
        int numSmelted = 0;
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack result;
            if (numSmelted > maxItemSmelt) break;
            Optional optional = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemEntity.m_32055_()}), world);
            if (!optional.isPresent() || (result = ((SmeltingRecipe)optional.get()).m_8043_().m_41777_()).m_41619_()) continue;
            while (numSmelted < maxItemSmelt && !itemEntity.m_32055_().m_41619_()) {
                itemEntity.m_32055_().m_41774_(1);
                world.m_7967_((Entity)new ItemEntity(world, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result.m_41777_()));
                ++numSmelted;
            }
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return rayTraceResult instanceof BlockHitResult;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Smelts blocks and items in the world. AOE will increase the number of items and radius of blocks that can be smelted at once, while Amplify will allow Smelt to work on blocks of higher hardness.";
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    public int getDefaultManaCost() {
        return 100;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_FIRE);
    }
}

