/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world;

import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.common.world.tree.SupplierBlockStateProvider;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class WorldEvent {
    public static ConfiguredFeature<TreeConfiguration, ?> CASCADING_TREE = Feature.f_65760_.m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider("blue_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (BlockStateProvider)new SupplierBlockStateProvider("blue_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_());
    public static ConfiguredFeature<TreeConfiguration, ?> BLAZING_TREE = Feature.f_65760_.m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider("red_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (BlockStateProvider)new SupplierBlockStateProvider("red_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_());
    public static ConfiguredFeature<TreeConfiguration, ?> FLOURISHING_TREE = Feature.f_65760_.m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider("green_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (BlockStateProvider)new SupplierBlockStateProvider("green_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_());
    public static ConfiguredFeature<TreeConfiguration, ?> VEXING_TREE = Feature.f_65760_.m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider("purple_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (BlockStateProvider)new SupplierBlockStateProvider("purple_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_());

    public static void registerFeatures() {
        ConfiguredFeature PATCH_BERRY_BUSH = FeatureUtils.m_195005_((String)"ars_nouveau:patch_berry", (ConfiguredFeature)Feature.f_65763_.m_65815_((FeatureConfiguration)FeatureUtils.m_194996_((ConfiguredFeature)Feature.f_65741_.m_65815_((FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)BlockRegistry.SOURCEBERRY_BUSH.m_49966_().m_61124_((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(3)))))), List.of(Blocks.f_50440_))));
        PlacedFeature BERRY_BUSH_PATCH_CONFIG = PlacementUtils.m_195368_((String)"ars_nouveau:placed_berry", (PlacedFeature)PATCH_BERRY_BUSH.m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}));
        float treeChance = ((Integer)Config.TREE_SPAWN_RATE.get()).floatValue();
        PlacedFeature PLACED_CASCADE = PlacementUtils.m_195368_((String)"ars_nouveau:placed_cascade", (PlacedFeature)CASCADING_TREE.m_190817_((Block)BlockRegistry.CASCADING_SAPLING));
        PlacedFeature PLACED_BLAZING = PlacementUtils.m_195368_((String)"ars_nouveau:placed_blazing", (PlacedFeature)BLAZING_TREE.m_190817_((Block)BlockRegistry.BLAZING_SAPLING));
        PlacedFeature PLACED_VEXING = PlacementUtils.m_195368_((String)"ars_nouveau:placed_vexing", (PlacedFeature)VEXING_TREE.m_190817_((Block)BlockRegistry.VEXING_SAPLING));
        PlacedFeature PLACED_FLOURISHING = PlacementUtils.m_195368_((String)"ars_nouveau:placed_flourishing", (PlacedFeature)FLOURISHING_TREE.m_190817_((Block)BlockRegistry.FLOURISHING_SAPLING));
        ConfiguredFeature CONFIGURED = FeatureUtils.m_195005_((String)"ars_nouveau:random_cascade", (ConfiguredFeature)Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PLACED_CASCADE, 0.25f), new WeightedPlacedFeature(PLACED_BLAZING, 0.25f), new WeightedPlacedFeature(PLACED_VEXING, 0.25f), new WeightedPlacedFeature(PLACED_FLOURISHING, 0.25f)), PLACED_CASCADE)));
        if ((Integer)Config.TREE_SPAWN_RATE.get() > 0) {
            PlacementUtils.m_195368_((String)"ars_nouveau:archwood", (PlacedFeature)CONFIGURED.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)((Integer)Config.TREE_SPAWN_RATE.get())))));
        }
    }

    @SubscribeEvent
    public static void biomeLoad(BiomeLoadingEvent e) {
        if (e.getCategory() == Biome.BiomeCategory.NETHER || e.getCategory() == Biome.BiomeCategory.THEEND) {
            return;
        }
        WorldEvent.addMobSpawns(e);
        if ((e.getCategory().equals((Object)Biome.BiomeCategory.TAIGA) || e.getName().equals((Object)new ResourceLocation("ars_nouveau", "archwood_forest"))) && ((Boolean)Config.SPAWN_BERRIES.get()).booleanValue()) {
            e.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, Objects.requireNonNull((PlacedFeature)BuiltinRegistries.f_194653_.m_7745_(new ResourceLocation("ars_nouveau:placed_berry")))).m_47831_();
        }
        e.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, Objects.requireNonNull((PlacedFeature)BuiltinRegistries.f_194653_.m_7745_(new ResourceLocation("ars_nouveau", "archwood"))));
    }

    public static void addMobSpawns(BiomeLoadingEvent e) {
        List<Biome.BiomeCategory> categories = Arrays.asList(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.JUNGLE, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.MOUNTAIN);
        if (categories.contains(e.getCategory())) {
            if ((Integer)Config.CARBUNCLE_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.STARBUNCLE_TYPE, ((Integer)Config.CARBUNCLE_WEIGHT.get()).intValue(), 1, 1));
            }
            if ((Integer)Config.SYLPH_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.WHIRLISPRIG_TYPE, ((Integer)Config.SYLPH_WEIGHT.get()).intValue(), 1, 1));
            }
        }
        if ((Integer)Config.DRYGMY_WEIGHT.get() > 0) {
            e.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.ENTITY_DRYGMY, ((Integer)Config.DRYGMY_WEIGHT.get()).intValue(), 1, 1));
        }
        if (!e.getCategory().equals((Object)Biome.BiomeCategory.MUSHROOM) && !e.getCategory().equals((Object)Biome.BiomeCategory.NONE)) {
            if (e.getClimate().f_47681_ <= 0.35f && (Integer)Config.WGUARDIAN_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.WILDEN_GUARDIAN, ((Integer)Config.WGUARDIAN_WEIGHT.get()).intValue(), 1, 1));
            }
            if ((Integer)Config.WSTALKER_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.WILDEN_STALKER, ((Integer)Config.WSTALKER_WEIGHT.get()).intValue(), 3, 3));
            }
            if ((Integer)Config.WHUNTER_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.WILDEN_HUNTER, ((Integer)Config.WHUNTER_WEIGHT.get()).intValue(), 1, 1));
            }
        }
    }
}

