/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.BuffStyle;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.items.EnvironmentalControllerItem;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderGameOverlayEventHandler {
    private static final int BUFF_ICON_SIZE = 16;
    public static List<PlayerBuff> buffs = null;

    public static void onRender(RenderGameOverlayEvent event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            return;
        }
        RenderGameOverlayEventHandler.renderBuffs(event.getMatrixStack());
    }

    private static void renderBuffs(PoseStack matrixStack) {
        if (buffs == null || buffs.isEmpty()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        McJtyLib.getPreferencesProperties((Player)player).ifPresent(preferences -> {
            BuffStyle style = preferences.getBuffStyle();
            if (style == BuffStyle.OFF) {
                return;
            }
            int x = preferences.getBuffX();
            int y = preferences.getBuffY();
            boolean leftToRight = true;
            switch (style) {
                case TOPLEFT: {
                    break;
                }
                case TOPRIGHT: {
                    leftToRight = false;
                    x = Minecraft.m_91087_().m_91268_().m_85445_() + x;
                    break;
                }
                case BOTLEFT: {
                    y = Minecraft.m_91087_().m_91268_().m_85446_() + y;
                    break;
                }
                case BOTRIGHT: {
                    leftToRight = false;
                    x = Minecraft.m_91087_().m_91268_().m_85445_() + x;
                    y = Minecraft.m_91087_().m_91268_().m_85446_() + y;
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            for (PlayerBuff buff : buffs) {
                Item item = RenderGameOverlayEventHandler.getBuffItem(buff);
                if (item == null) continue;
                ItemRenderer itemRender = Minecraft.m_91087_().m_91291_();
                RenderHelper.renderItemStack((PoseStack)matrixStack, (ItemRenderer)itemRender, (ItemStack)new ItemStack((ItemLike)item), (int)x, (int)y, (String)"", (boolean)false);
                if (leftToRight) {
                    x += 16;
                    continue;
                }
                x -= 16;
            }
        });
    }

    private static Item getBuffItem(PlayerBuff buff) {
        EnvironmentalControllerItem item = switch (buff) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerBuff.BUFF_FEATHERFALLING -> (EnvironmentalControllerItem)EnvironmentalModule.FEATHERFALLING_MODULE.get();
            case PlayerBuff.BUFF_FEATHERFALLINGPLUS -> (EnvironmentalControllerItem)EnvironmentalModule.FEATHERFALLINGPLUS_MODULE.get();
            case PlayerBuff.BUFF_HASTE -> (EnvironmentalControllerItem)EnvironmentalModule.HASTE_MODULE.get();
            case PlayerBuff.BUFF_HASTEPLUS -> (EnvironmentalControllerItem)EnvironmentalModule.HASTEPLUS_MODULE.get();
            case PlayerBuff.BUFF_REGENERATION -> (EnvironmentalControllerItem)EnvironmentalModule.REGENERATION_MODULE.get();
            case PlayerBuff.BUFF_REGENERATIONPLUS -> (EnvironmentalControllerItem)EnvironmentalModule.REGENERATIONPLUS_MODULE.get();
            case PlayerBuff.BUFF_SATURATION -> (EnvironmentalControllerItem)EnvironmentalModule.SATURATION_MODULE.get();
            case PlayerBuff.BUFF_SATURATIONPLUS -> (EnvironmentalControllerItem)EnvironmentalModule.SATURATIONPLUS_MODULE.get();
            case PlayerBuff.BUFF_SPEED -> (EnvironmentalControllerItem)EnvironmentalModule.SPEED_MODULE.get();
            case PlayerBuff.BUFF_SPEEDPLUS -> (EnvironmentalControllerItem)EnvironmentalModule.SPEEDPLUS_MODULE.get();
            case PlayerBuff.BUFF_FLIGHT -> (EnvironmentalControllerItem)EnvironmentalModule.FLIGHT_MODULE.get();
            case PlayerBuff.BUFF_PEACEFUL -> (EnvironmentalControllerItem)EnvironmentalModule.PEACEFUL_MODULE.get();
            case PlayerBuff.BUFF_GLOWING -> (EnvironmentalControllerItem)EnvironmentalModule.GLOWING_MODULE.get();
            case PlayerBuff.BUFF_WATERBREATHING -> (EnvironmentalControllerItem)EnvironmentalModule.WATERBREATHING_MODULE.get();
            case PlayerBuff.BUFF_NIGHTVISION -> (EnvironmentalControllerItem)EnvironmentalModule.NIGHTVISION_MODULE.get();
            case PlayerBuff.BUFF_BLINDNESS -> (EnvironmentalControllerItem)EnvironmentalModule.BLINDNESS_MODULE.get();
            case PlayerBuff.BUFF_WEAKNESS -> (EnvironmentalControllerItem)EnvironmentalModule.WEAKNESS_MODULE.get();
            case PlayerBuff.BUFF_POISON -> (EnvironmentalControllerItem)EnvironmentalModule.POISON_MODULE.get();
            case PlayerBuff.BUFF_SLOWNESS -> (EnvironmentalControllerItem)EnvironmentalModule.SLOWNESS_MODULE.get();
            case PlayerBuff.BUFF_LUCK -> (EnvironmentalControllerItem)EnvironmentalModule.LUCK_MODULE.get();
            case PlayerBuff.BUFF_NOTELEPORT -> (EnvironmentalControllerItem)EnvironmentalModule.NOTELEPORT_MODULE.get();
        };
        return item;
    }
}

