/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.TagSelector;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.InventoryTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.InvCheckerDamageMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class InvCheckerTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    public static final int SLOT_ITEMMATCH = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.ghost(), 0, 154, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.no()).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Inventory Checker").containerSupplier(DefaultContainerProvider.container(LogicBlockModule.CONTAINER_INVCHECKER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @GuiValue
    private int amount = 1;
    @GuiValue
    private int slot = 0;
    @GuiValue(name="damage")
    private InvCheckerDamageMode useDamage = InvCheckerDamageMode.DMG_IGNORE;
    private Tags.IOptionalNamedTag<Item> tag = null;
    private int checkCounter = 0;
    @ServerCommand
    public static final Command<?> CMD_SETTAG = Command.create((String)"inv.setTag", (te, player, params) -> te.setTagByName((String)params.get(TagSelector.PARAM_TAG)));

    public InvCheckerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.TYPE_INVCHECKER.get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/invchecker")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(InvCheckerTileEntity::new));
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.m_6596_();
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.m_6596_();
    }

    public Tags.IOptionalNamedTag<Item> getTag() {
        return this.tag;
    }

    public void setTag(Tags.IOptionalNamedTag<Item> tag) {
        this.tag = tag;
        this.m_6596_();
    }

    public void setTagByName(String tagName) {
        this.tag = tagName == null ? null : this.getiNamedTag(tagName);
        this.markDirtyClient();
    }

    private Tags.IOptionalNamedTag<Item> getiNamedTag(String tagName) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation(tagName));
    }

    public String getTagName() {
        return this.tag == null ? null : this.tag.m_6979_().toString();
    }

    public InvCheckerDamageMode isUseDamage() {
        return this.useDamage;
    }

    public void setUseDamage(InvCheckerDamageMode useDamage) {
        this.useDamage = useDamage;
        this.m_6596_();
    }

    protected void tickServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput() ? 15 : 0);
    }

    public boolean checkOutput() {
        Direction inputSide = LogicSupport.getFacing((BlockState)this.f_58857_.m_8055_(this.m_58899_())).getInputSide();
        BlockPos inputPos = this.m_58899_().m_142300_(inputSide);
        BlockEntity te = this.f_58857_.m_7702_(inputPos);
        if (InventoryTools.isInventory((BlockEntity)te)) {
            return CapabilityTools.getItemCapabilitySafe((BlockEntity)te).map(capability -> {
                int nr;
                ItemStack stack;
                if (this.slot >= 0 && this.slot < capability.getSlots() && !(stack = capability.getStackInSlot(this.slot)).m_41619_() && (nr = this.isItemMatching(stack)) >= this.amount) {
                    if (this.tag != null) {
                        return this.tag.m_8110_((Object)stack.m_41720_());
                    }
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private int isItemMatching(ItemStack stack) {
        int nr = 0;
        ItemStack matcher = this.items.getStackInSlot(0);
        if (!matcher.m_41619_()) {
            if (this.useDamage == InvCheckerDamageMode.DMG_MATCH) {
                if (matcher.m_41656_(stack)) {
                    nr = stack.m_41613_();
                }
            } else if (matcher.m_41720_() == stack.m_41720_()) {
                nr = stack.m_41613_();
            }
        } else {
            nr = stack.m_41613_();
        }
        return nr;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
    }

    public void loadInfo(CompoundTag tagCompound) {
        String tagString;
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        if (info.m_128441_("amount")) {
            this.amount = info.m_128451_("amount");
        }
        if (info.m_128441_("slot")) {
            this.slot = info.m_128451_("slot");
        }
        if (info.m_128441_("tag") && !(tagString = info.m_128461_("tag")).isEmpty()) {
            this.tag = this.getiNamedTag(tagString);
        }
        if (info.m_128441_("useDamage")) {
            this.useDamage = info.m_128471_("useDamage") ? InvCheckerDamageMode.DMG_MATCH : InvCheckerDamageMode.DMG_IGNORE;
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("amount", this.amount);
        info.m_128405_("slot", this.slot);
        if (this.tag != null) {
            info.m_128359_("tag", this.tag.m_6979_().toString());
        }
        info.m_128379_("useDamage", this.useDamage == InvCheckerDamageMode.DMG_MATCH);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.tag != null) {
            info.m_128359_("tag", this.tag.m_6979_().toString());
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        String tagString;
        CompoundTag info = tagCompound.m_128469_("Info");
        if (info.m_128441_("tag") && !(tagString = info.m_128461_("tag")).isEmpty()) {
            this.tag = this.getiNamedTag(tagString);
        }
    }
}

