/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ElevatorButtonScreenModule
implements IScreenModule<ModuleElevatorInfo> {
    private ResourceKey<Level> dim = Level.f_46428_;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private ScreenModuleHelper helper = new ScreenModuleHelper();

    public ModuleElevatorInfo getData(IScreenDataHelper helper, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        BlockEntity te = world.m_7702_(this.coordinate);
        return null;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.m_128441_("elevatorx")) {
                this.dim = tagCompound.m_128441_("elevatordim") ? LevelTools.getId((String)tagCompound.m_128461_("elevatordim")) : LevelTools.getId((String)tagCompound.m_128461_("dim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.m_128451_("elevatorx"), tagCompound.m_128451_("elevatory"), tagCompound.m_128451_("elevatorz"));
                    int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                    int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                    if (dx <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
                boolean vertical = tagCompound.m_128471_("vertical");
                boolean bl = tagCompound.m_128471_("large");
            }
        }
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            if (player != null) {
                player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Module is not linked to elevator!"), false);
            }
            return;
        }
        ServerLevel w = LevelTools.getLevel((Level)world, this.dim);
        if (w == null) {
            return;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return;
        }
    }

    public static int getColumnWidth(int numcols) {
        return switch (numcols) {
            case 1 -> 120;
            case 2 -> 58;
            case 3 -> 36;
            case 4 -> 25;
            case 5 -> 19;
            default -> 15;
        };
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.ELEVATOR_BUTTON_RFPERTICK.get();
    }

    public static class ModuleElevatorInfo
    implements IModuleData {
        public static final String ID = "rftoolsutility:elevator";
        private int level;
        private int maxLevel;
        private BlockPos pos;
        private List<Integer> heights;

        public String getId() {
            return ID;
        }

        public ModuleElevatorInfo(int level, int maxLevel, BlockPos pos, List<Integer> heights) {
            this.level = level;
            this.maxLevel = maxLevel;
            this.pos = pos;
            this.heights = heights;
        }

        public ModuleElevatorInfo(FriendlyByteBuf buf) {
            this.level = buf.readInt();
            this.maxLevel = buf.readInt();
            this.pos = buf.m_130135_();
            int s = buf.readByte();
            this.heights = new ArrayList<Integer>(s);
            for (int i = 0; i < s; ++i) {
                this.heights.add(Integer.valueOf(buf.readShort()));
            }
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public List<Integer> getHeights() {
            return this.heights;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void writeToBuf(FriendlyByteBuf buf) {
            buf.writeInt(this.level);
            buf.writeInt(this.maxLevel);
            buf.m_130064_(this.pos);
            buf.writeByte(this.heights.size());
            for (Integer height : this.heights) {
                buf.writeShort(height.intValue());
            }
        }
    }
}

