/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipe;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SpawnerRecipeBuilder {
    private final ResourceLocation id;
    private final ResourceLocation entity;
    private int power = 0;
    private SpawnerRecipes.MobSpawnAmount item1;
    private SpawnerRecipes.MobSpawnAmount item2;
    private SpawnerRecipes.MobSpawnAmount item3;

    private SpawnerRecipeBuilder(EntityType entity) {
        this.id = new ResourceLocation("rftoolsutility", entity.getRegistryName().m_135827_() + "_" + entity.getRegistryName().m_135815_());
        this.entity = entity.getRegistryName();
    }

    public static SpawnerRecipeBuilder create(EntityType entity) {
        return new SpawnerRecipeBuilder(entity);
    }

    public SpawnerRecipeBuilder power(int power) {
        this.power = power;
        return this;
    }

    public SpawnerRecipeBuilder item1(Ingredient ingredient, float amount) {
        this.item1 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        return this;
    }

    public SpawnerRecipeBuilder item2(Ingredient ingredient, float amount) {
        this.item2 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        return this;
    }

    public SpawnerRecipeBuilder item3(Ingredient ingredient, float amount) {
        this.item3 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        consumerIn.accept(new Result(new SpawnerRecipe(this.id, this.item1, this.item2, this.item3, this.power, this.entity)));
    }

    public static class Result
    implements FinishedRecipe {
        private final SpawnerRecipe recipe;

        public Result(SpawnerRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("id", (JsonElement)new JsonPrimitive(this.recipe.m_6423_().toString()));
            json.add("power", (JsonElement)new JsonPrimitive((Number)this.recipe.getSpawnRf()));
            json.add("entity", (JsonElement)new JsonPrimitive(this.recipe.getEntity().toString()));
            this.serializeItem(json, this.recipe.getItem1(), "item1");
            this.serializeItem(json, this.recipe.getItem2(), "item2");
            this.serializeItem(json, this.recipe.getItem3(), "item3");
        }

        private void serializeItem(JsonObject json, SpawnerRecipes.MobSpawnAmount item1, String tag) {
            JsonObject itemObject = new JsonObject();
            itemObject.add("amount", (JsonElement)new JsonPrimitive((Number)Float.valueOf(item1.getAmount())));
            if (item1.getObject() != null && item1.getObject() != Ingredient.f_43901_) {
                itemObject.add("ingredient", item1.getObject().m_43942_());
            } else {
                itemObject.add("living", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
            json.add(tag, (JsonElement)itemObject);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)SpawnerModule.SPAWNER_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

