/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.recipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SpawnerRecipes {
    private static final Map<String, MobData> mobData = new HashMap<String, MobData>();

    public static MobData getMobData(Level world, String id) {
        MobData data;
        if (mobData.isEmpty()) {
            SpawnerRecipes.loadRecipes(world);
        }
        if ((data = mobData.get(id)) == null) {
            return null;
        }
        return data;
    }

    private static void loadRecipes(Level world) {
        mobData.clear();
        List recipes = world.m_7465_().m_44013_((RecipeType)SpawnerModule.SPAWNER_RECIPE_TYPE);
        for (SpawnerRecipe recipe : recipes) {
            mobData.put(recipe.getEntity().toString(), MobData.create().item1(recipe.getItem1()).item2(recipe.getItem2()).item3(recipe.getItem3()).spawnRf(recipe.getSpawnRf()));
        }
    }

    public static class MobData {
        private MobSpawnAmount item1;
        private MobSpawnAmount item2;
        private MobSpawnAmount item3;
        private int spawnRf;

        public static MobData create() {
            return new MobData();
        }

        public MobData item1(MobSpawnAmount item1) {
            this.item1 = item1;
            return this;
        }

        public MobData item2(MobSpawnAmount item2) {
            this.item2 = item2;
            return this;
        }

        public MobData item3(MobSpawnAmount item3) {
            this.item3 = item3;
            return this;
        }

        public MobData spawnRf(int spawnRf) {
            this.spawnRf = spawnRf;
            return this;
        }

        public MobSpawnAmount getItem1() {
            return this.item1;
        }

        public MobSpawnAmount getItem2() {
            return this.item2;
        }

        public MobSpawnAmount getItem3() {
            return this.item3;
        }

        public MobSpawnAmount getItem(int index) {
            switch (index) {
                case 0: {
                    return this.item1;
                }
                case 1: {
                    return this.item2;
                }
                case 2: {
                    return this.item3;
                }
            }
            throw new IllegalStateException("Bad index for MobData.getItem()!");
        }

        public int getSpawnRf() {
            return this.spawnRf;
        }
    }

    public static class MobSpawnAmount {
        private final Ingredient object;
        private final float amount;

        public MobSpawnAmount(Ingredient object, float amount) {
            this.object = object;
            this.amount = amount;
        }

        public static MobSpawnAmount create(Ingredient object, float amount) {
            return new MobSpawnAmount(object, amount);
        }

        public Ingredient getObject() {
            return this.object;
        }

        public float getAmount() {
            return this.amount;
        }

        public Float match(ItemStack stack) {
            if (this.object.m_43947_()) {
                Item item = stack.m_41720_();
                Set tags = item.getTags();
                if (tags.contains(SpawnerConfiguration.HIGHYIELD)) {
                    return Float.valueOf(1.5f);
                }
                if (tags.contains(SpawnerConfiguration.AVERAGEYIELD)) {
                    return Float.valueOf(1.0f);
                }
                if (tags.contains(SpawnerConfiguration.LOWYIELD)) {
                    return Float.valueOf(0.5f);
                }
                return Float.valueOf(0.0f);
            }
            if (this.object.test(stack)) {
                return Float.valueOf(1.0f);
            }
            return null;
        }
    }
}

