/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.example.GeckoLibMod;
import software.bernie.geckolib3.GeckoLib;
import tech.thatgravyboat.creeperoverhaul.client.ClientConfig;
import tech.thatgravyboat.creeperoverhaul.common.Events;
import tech.thatgravyboat.creeperoverhaul.common.entity.CreeperTypes;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModBlocks;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModItems;

@Mod(value="creeperoverhaul")
public class Creepers {
    public static final String MODID = "creeperoverhaul";
    private static Boolean usingOptifine = null;
    public static final Events EVENT = Events.getCurrentEvent();

    public Creepers() {
        GeckoLibMod.DISABLE_IN_DEV = true;
        GeckoLib.initialize();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEntities.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        modEventBus.addListener(this::addAttributes);
        modEventBus.addListener(this::onComplete);
        modEventBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isUsingOptifine() {
        if (usingOptifine == null) {
            try {
                Class.forName("optifine.Installer");
                usingOptifine = true;
            }
            catch (Exception ignored) {
                usingOptifine = false;
            }
        }
        return usingOptifine;
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        Creeper creeper;
        BaseCreeper baseCreeper;
        Entity killer;
        LivingEntity livingEntity = event.getEntityLiving();
        Level level = event.getEntityLiving().f_19853_;
        BlockPos pos = event.getEntityLiving().m_142538_();
        if (level.m_46469_().m_46207_(GameRules.f_46135_) && ((killer = event.getSource().m_7639_()) instanceof BaseCreeper && (baseCreeper = (BaseCreeper)killer).canDropMobsSkull() || killer instanceof Creeper && (creeper = (Creeper)killer).m_32313_())) {
            Item skull = null;
            if (livingEntity instanceof Skeleton) {
                skull = Items.f_42678_;
            }
            if (livingEntity instanceof Creeper || livingEntity instanceof BaseCreeper) {
                skull = Items.f_42682_;
            }
            if (livingEntity instanceof WitherSkeleton) {
                skull = Items.f_42679_;
            }
            if (livingEntity instanceof Zombie) {
                skull = Items.f_42681_;
            }
            if (skull != null) {
                if (killer instanceof BaseCreeper) {
                    BaseCreeper baseCreeper2 = (BaseCreeper)killer;
                    baseCreeper2.increaseDroppedSkulls();
                }
                if (killer instanceof Creeper) {
                    Creeper creeper2 = (Creeper)killer;
                    creeper2.m_32314_();
                }
                event.getDrops().add(new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)skull)));
            }
        }
    }

    public void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.JUNGLE_CREEPER.get(), CreeperTypes.JUNGLE.attributes());
        event.put((EntityType)ModEntities.BAMBOO_CREEPER.get(), CreeperTypes.BAMBOO.attributes());
        event.put((EntityType)ModEntities.DESERT_CREEPER.get(), CreeperTypes.DESERT.attributes());
        event.put((EntityType)ModEntities.BADLANDS_CREEPER.get(), CreeperTypes.BADLANDS.attributes());
        event.put((EntityType)ModEntities.HILLS_CREEPER.get(), CreeperTypes.HILLS.attributes());
        event.put((EntityType)ModEntities.SAVANNAH_CREEPER.get(), CreeperTypes.SAVANNAH.attributes());
        event.put((EntityType)ModEntities.MUSHROOM_CREEPER.get(), CreeperTypes.MUSHROOM.attributes());
        event.put((EntityType)ModEntities.SWAMP_CREEPER.get(), CreeperTypes.SWAMP.attributes());
        event.put((EntityType)ModEntities.DRIPSTONE_CREEPER.get(), CreeperTypes.DRIPSTONE.attributes());
        event.put((EntityType)ModEntities.CAVE_CREEPER.get(), CreeperTypes.CAVE.attributes());
        event.put((EntityType)ModEntities.DARK_OAK_CREEPER.get(), CreeperTypes.DARK_OAK.attributes());
        event.put((EntityType)ModEntities.SPRUCE_CREEPER.get(), CreeperTypes.SPRUCE.attributes());
        event.put((EntityType)ModEntities.BEACH_CREEPER.get(), CreeperTypes.BEACH.attributes());
        event.put((EntityType)ModEntities.SNOWY_CREEPER.get(), CreeperTypes.SNOWY.attributes());
    }

    public void onComplete(FMLLoadCompleteEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.JUNGLE_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.BAMBOO_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, Creepers::checkDayMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.DESERT_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.BADLANDS_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.HILLS_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.SAVANNAH_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.MUSHROOM_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkDayMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.SWAMP_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.DRIPSTONE_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesCave);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.CAVE_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesCave);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.DARK_OAK_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.SPRUCE_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.BEACH_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkMonsterSpawnRulesAbove);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.SNOWY_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepers::checkDayMonsterSpawnRulesAbove);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(new ResourceLocation(MODID, "tiny_cactus"), ModBlocks.TINY_CACTUS_POT);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addCreepers(BiomeLoadingEvent event) {
        switch (event.getCategory()) {
            case BEACH: {
                this.addCreeper(event, ModEntities.BEACH_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case ICY: {
                this.addCreeper(event, ModEntities.SNOWY_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case DESERT: {
                this.addCreeper(event, ModEntities.DESERT_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case EXTREME_HILLS: {
                this.addCreeper(event, ModEntities.HILLS_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case SAVANNA: {
                this.addCreeper(event, ModEntities.SAVANNAH_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case MESA: {
                this.addCreeper(event, ModEntities.BADLANDS_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case MUSHROOM: {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.MUSHROOM_CREEPER.get(), 10, 1, 2));
                break;
            }
            case TAIGA: {
                this.addCreeper(event, ModEntities.SPRUCE_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case MOUNTAIN: {
                this.addCreeper(event, event.getClimate().f_47680_.equals((Object)Biome.Precipitation.SNOW) ? ModEntities.SNOWY_CREEPER : ModEntities.HILLS_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case UNDERGROUND: {
                this.addCreeper(event, ModEntities.DRIPSTONE_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case JUNGLE: {
                this.addCreeper(event, ModEntities.JUNGLE_CREEPER);
                this.addCreeper(event, ModEntities.BAMBOO_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            case SWAMP: {
                this.addCreeper(event, ModEntities.SWAMP_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
                break;
            }
            default: {
                if (event.getName() == null || !event.getName().m_135815_().equals("dark_forest")) break;
                this.addCreeper(event, ModEntities.DARK_OAK_CREEPER);
                this.addCreeper(event, ModEntities.CAVE_CREEPER);
            }
        }
    }

    @SubscribeEvent
    public void removeCreepers(BiomeLoadingEvent event) {
        switch (event.getCategory()) {
            case BEACH: 
            case ICY: 
            case DESERT: 
            case EXTREME_HILLS: 
            case SAVANNA: 
            case MESA: 
            case MUSHROOM: 
            case TAIGA: 
            case MOUNTAIN: 
            case UNDERGROUND: 
            case JUNGLE: 
            case SWAMP: {
                event.getSpawns().getSpawner(MobCategory.MONSTER).removeIf(data -> data.f_48404_.equals(EntityType.f_20558_));
                break;
            }
            default: {
                if (event.getName() == null || !event.getName().m_135815_().equals("dark_forest")) break;
                event.getSpawns().getSpawner(MobCategory.MONSTER).removeIf(data -> data.f_48404_.equals(EntityType.f_20558_));
            }
        }
    }

    public static boolean checkMonsterSpawnRulesCave(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        return pPos.m_123342_() < pLevel.m_5736_() && !pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50440_) && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (Random)pRandom) && Monster.m_21400_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (Random)pRandom);
    }

    public static boolean checkMonsterSpawnRulesAbove(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        return pPos.m_123342_() > pLevel.m_5736_() && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (Random)pRandom) && Monster.m_21400_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (Random)pRandom);
    }

    public static boolean checkDayMonsterSpawnRulesAbove(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        BlockState state = pLevel.m_8055_(pPos.m_7495_());
        boolean isGrassLike = state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50493_);
        return pPos.m_123342_() > pLevel.m_5736_() && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_21400_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (Random)pRandom) && (isGrassLike || state.m_60620_((Tag)BlockTags.f_13061_) || state.m_60734_() instanceof LeavesBlock);
    }

    private <E extends BaseCreeper> void addCreeper(BiomeLoadingEvent event, RegistryObject<EntityType<E>> entityType) {
        event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)entityType.get(), 75, 2, 2));
    }
}

