/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.crafting.TagMapper;
import com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe;
import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedTagRecipe
extends ShapedNoMirrorRecipe {
    public ShapedTagRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> inputs, ItemStack output) {
        super(id, group, width, height, inputs, output);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.CRAFTING_SHAPED_TAG;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapedTagRecipe> {
        public ShapedTagRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)width, (int)height);
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            String tag = GsonHelper.m_13906_((JsonObject)result, (String)"tag");
            int count = GsonHelper.m_13824_((JsonObject)result, (String)"count", (int)1);
            Item item = TagMapper.getItemForTag(tag);
            if (item == Items.f_41852_) {
                return null;
            }
            ItemStack output = new ItemStack((ItemLike)item, count);
            return new ShapedTagRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public ShapedTagRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new ShapedTagRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedTagRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

