/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAntChamber;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAnthill;
import com.github.alexthe666.alexsmobs.entity.EntityAnteater;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class AnteaterAIRaidNest
extends MoveToBlockGoal {
    public static final ResourceLocation ANTEATER_REWARD = new ResourceLocation("alexsmobs", "gameplay/anteater_reward");
    private EntityAnteater anteater;
    private int idleAtHiveTime = 0;
    private boolean isAboveDestinationAnteater;
    private boolean shootTongue;
    private int maxEatingTime = 0;

    public AnteaterAIRaidNest(EntityAnteater anteater) {
        super((PathfinderMob)anteater, 1.0, 32, 8);
        this.anteater = anteater;
    }

    private static List<ItemStack> getItemStacks(EntityAnteater anteater) {
        LootTable loottable = anteater.f_19853_.m_142572_().m_129898_().m_79217_(ANTEATER_REWARD);
        return loottable.m_79129_(new LootContext.Builder((ServerLevel)anteater.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)anteater).m_78977_(anteater.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
    }

    private void dropDigItems() {
        List<ItemStack> lootList = AnteaterAIRaidNest.getItemStacks(this.anteater);
        if (lootList.size() > 0) {
            for (ItemStack stack : lootList) {
                ItemEntity e = this.anteater.m_19983_(stack.m_41777_());
                e.f_19812_ = true;
                e.m_20256_(e.m_20184_().m_82542_(0.2, 0.2, 0.2));
            }
        }
    }

    public boolean m_8036_() {
        return !this.anteater.m_6162_() && super.m_8036_() && this.anteater.eatAntCooldown <= 0;
    }

    public boolean m_8045_() {
        return super.m_8045_() && this.anteater.eatAntCooldown <= 0;
    }

    public void m_8056_() {
        super.m_8056_();
        this.maxEatingTime = 150 + this.anteater.m_21187_().nextInt(200);
    }

    public void m_8041_() {
        super.m_8041_();
        this.idleAtHiveTime = 0;
        this.maxEatingTime = 150 + this.anteater.m_21187_().nextInt(200);
        this.anteater.setLeaning(false);
        this.anteater.resetAntCooldown();
    }

    public double m_8052_() {
        return 1.2;
    }

    public void m_8037_() {
        super.m_8037_();
        BlockPos blockpos = this.m_6669_();
        if (!this.isWithinXZDist(blockpos, this.f_25598_.m_20182_(), this.m_8052_())) {
            this.isAboveDestinationAnteater = false;
            ++this.f_25601_;
            if (this.m_8064_()) {
                this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
            }
        } else {
            this.isAboveDestinationAnteater = true;
            --this.f_25601_;
        }
        if (this.m_25625_()) {
            this.anteater.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() - 1), (double)this.f_25602_.m_123343_() + 0.5));
            if (this.idleAtHiveTime >= 20 && this.idleAtHiveTime % 20 == 0) {
                boolean bl = this.shootTongue = this.anteater.m_21187_().nextInt(2) == 0;
                if (this.shootTongue) {
                    this.eatHive();
                } else {
                    this.breakHiveEffect();
                }
            }
            ++this.idleAtHiveTime;
            if (this.shootTongue && this.anteater.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.anteater.setLeaning(false);
                this.anteater.setAnimation(EntityAnteater.ANIMATION_TOUNGE_IDLE);
            } else if (this.anteater.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.anteater.setLeaning(true);
                this.anteater.setAnimation(this.anteater.m_21187_().nextBoolean() ? EntityAnteater.ANIMATION_SLASH_L : EntityAnteater.ANIMATION_SLASH_R);
            }
            if (this.idleAtHiveTime > this.maxEatingTime) {
                this.m_8041_();
            }
        }
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
        return blockpos.m_123299_(positionVec.m_7096_(), (double)blockpos.m_123342_(), positionVec.m_7094_(), true) < distance * distance;
    }

    protected boolean m_25625_() {
        return this.isAboveDestinationAnteater;
    }

    private void breakHiveEffect() {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.anteater.f_19853_, (Entity)this.anteater)) {
            BlockState blockstate = this.anteater.f_19853_.m_8055_(this.f_25602_);
            if (blockstate.m_60713_(AMBlockRegistry.LEAFCUTTER_ANTHILL)) {
                if (this.anteater.f_19853_.m_7702_(this.f_25602_) instanceof TileEntityLeafcutterAnthill) {
                    TileEntityLeafcutterAnthill anthill = (TileEntityLeafcutterAnthill)this.anteater.f_19853_.m_7702_(this.f_25602_);
                    anthill.angerAntsBecauseAnteater((LivingEntity)this.anteater, blockstate, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                    this.anteater.f_19853_.m_46961_(this.f_25602_, false);
                    if (blockstate.m_60734_() instanceof BlockLeafcutterAnthill) {
                        this.anteater.f_19853_.m_46597_(this.f_25602_, blockstate);
                    }
                    this.dropDigItems();
                }
            } else if (blockstate.m_60713_(AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER)) {
                this.anteater.f_19853_.m_46961_(this.f_25602_, false);
                this.anteater.f_19853_.m_46597_(this.f_25602_, blockstate);
            }
        }
    }

    private void eatHive() {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.anteater.f_19853_, (Entity)this.anteater)) {
            BlockState blockstate = this.anteater.f_19853_.m_8055_(this.f_25602_);
            if (blockstate.m_60713_(AMBlockRegistry.LEAFCUTTER_ANTHILL)) {
                if (this.anteater.f_19853_.m_7702_(this.f_25602_) instanceof TileEntityLeafcutterAnthill) {
                    rand = new Random();
                    TileEntityLeafcutterAnthill anthill = (TileEntityLeafcutterAnthill)this.anteater.f_19853_.m_7702_(this.f_25602_);
                    anthill.angerAntsBecauseAnteater((LivingEntity)this.anteater, blockstate, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                    this.anteater.f_19853_.m_46717_(this.f_25602_, blockstate.m_60734_());
                    if (!anthill.hasNoAnts()) {
                        BlockState state = anthill.shrinkFungus();
                        if (state != null && state.m_60713_(AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER) && (Integer)state.m_61143_((Property)BlockLeafcutterAntChamber.FUNGUS) >= 5) {
                            ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.GONGYLIDIA);
                            ItemEntity itementity = new ItemEntity(this.anteater.f_19853_, (double)((float)this.f_25602_.m_123341_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123342_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123343_() + rand.nextFloat()), stack);
                            itementity.m_32060_();
                            this.anteater.f_19853_.m_7967_((Entity)itementity);
                        }
                        this.anteater.setAntOnTongue(true);
                    }
                }
            } else if (blockstate.m_60713_(AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER)) {
                this.anteater.f_19853_.m_46961_(this.f_25602_, false);
                if ((Integer)blockstate.m_61143_((Property)BlockLeafcutterAntChamber.FUNGUS) >= 5) {
                    rand = new Random();
                    ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.GONGYLIDIA);
                    ItemEntity itementity = new ItemEntity(this.anteater.f_19853_, (double)((float)this.f_25602_.m_123341_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123342_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123343_() + rand.nextFloat()), stack);
                    itementity.m_32060_();
                    this.anteater.f_19853_.m_7967_((Entity)itementity);
                }
                this.anteater.f_19853_.m_46597_(this.f_25602_, Blocks.f_50546_.m_49966_());
                this.anteater.setAntOnTongue(true);
            }
            double d0 = 15.0;
            for (EntityLeafcutterAnt leafcutter : this.anteater.f_19853_.m_45976_(EntityLeafcutterAnt.class, new AABB((double)this.f_25602_.m_123341_() - d0, (double)this.f_25602_.m_123342_() - d0, (double)this.f_25602_.m_123343_() - d0, (double)this.f_25602_.m_123341_() + d0, (double)this.f_25602_.m_123342_() + d0, (double)this.f_25602_.m_123343_() + d0))) {
                leafcutter.m_7870_(100);
                leafcutter.m_6710_((LivingEntity)this.anteater);
                leafcutter.setStayOutOfHiveCountdown(400);
            }
        }
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60713_(AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER) || worldIn.m_8055_(pos).m_60713_(AMBlockRegistry.LEAFCUTTER_ANTHILL) && worldIn.m_7702_(pos) instanceof TileEntityLeafcutterAnthill && this.isValidAnthill(pos, (TileEntityLeafcutterAnthill)worldIn.m_7702_(pos));
    }

    private boolean isValidAnthill(BlockPos pos, TileEntityLeafcutterAnthill blockEntity) {
        return blockEntity.hasAtleastThisManyAnts(2);
    }
}

