/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class FilteredPlayerListWidget
implements Widget,
NarratableEntry,
GuiEventListener {
    private static final int ENTRY_PER_SCREEN = 3;
    private static final int ITEM_HEIGHT = 12;
    private static final int WIDTH = 101;
    private static final int HEIGHT = 36;
    private static final int SCROLLER_W = 6;
    private static final int SCROLLER_H = 17;
    private static final int SCROLLER_X = 102;
    private final List<SimplePlayerEntry> allPlayers = new ArrayList<SimplePlayerEntry>();
    private final List<SimplePlayerEntry> filtered = new ArrayList<SimplePlayerEntry>();
    private final Minecraft minecraft;
    protected final int x;
    protected final int y;
    protected final int x1;
    protected final int y1;
    private final Consumer<String> onClick;
    private String filter;
    private int scrollOff;
    private boolean isDragging;

    public FilteredPlayerListWidget(Minecraft minecraft, int x, int y, Consumer<String> onClick) {
        this.minecraft = minecraft;
        this.x = x;
        this.y = y;
        this.x1 = x + 101;
        this.y1 = y + 36;
        this.onClick = onClick;
        Collection collection = this.minecraft.f_91074_.f_108617_.m_105143_();
        for (UUID uuid : collection) {
            PlayerInfo playerinfo = this.minecraft.f_91074_.f_108617_.m_104949_(uuid);
            if (playerinfo == null) continue;
            this.allPlayers.add(new SimplePlayerEntry(playerinfo, this.minecraft.f_91062_));
        }
        this.filtered.addAll(this.allPlayers);
    }

    public List<String> setFilter(@Nullable String filter) {
        if (filter == null) {
            filter = "";
        }
        this.filter = filter.toLowerCase(Locale.ROOT);
        this.updateFilteredEntries();
        return this.filtered.stream().map(SimplePlayerEntry::getName).toList();
    }

    private void updateFilteredEntries() {
        this.filtered.clear();
        this.filtered.addAll(this.allPlayers.stream().filter(s -> s.getName().toLowerCase(Locale.ROOT).startsWith(this.filter)).toList());
    }

    public void addPlayer(PlayerInfo info) {
        this.allPlayers.add(new SimplePlayerEntry(info, this.minecraft.f_91062_));
        this.updateFilteredEntries();
    }

    public void removePlayer(UUID id) {
        for (SimplePlayerEntry simplePlayerEntry : this.allPlayers) {
            if (!simplePlayerEntry.getId().equals(id)) continue;
            this.allPlayers.remove(simplePlayerEntry);
            this.updateFilteredEntries();
            return;
        }
    }

    private boolean canScroll() {
        return this.filtered.size() > 3;
    }

    public boolean m_6375_(double mouseX, double mouseY, int key) {
        SimplePlayerEntry e;
        boolean bl = this.isDragging = this.canScroll() && mouseX > (double)(this.x + 102) && mouseX < (double)(this.x + 102 + 6) && mouseY > (double)this.y && mouseY <= (double)(this.y + 36 + 1);
        if (this.m_5953_(mouseX, mouseY) && (e = this.getEntryAtPosition(mouseX, mouseY)) != null) {
            this.onClick.accept(e.playerName);
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        return false;
    }

    public boolean m_7979_(double dx, double dy, int key, double mouseX, double mouseY) {
        if (this.isDragging) {
            int j = this.filtered.size() - 3;
            float f = ((float)dy - (float)this.y - 13.5f) / ((float)(this.y1 - this.y) - 17.0f);
            f = f * (float)j + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)j);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double a, double b, double c) {
        if (this.canScroll()) {
            int j = this.filtered.size() - 3;
            this.scrollOff = (int)((double)this.scrollOff - c);
            this.scrollOff = Mth.m_14045_((int)this.scrollOff, (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7933_(int key, int a, int b) {
        if (key == 265) {
            this.scrollOff = Math.max(0, this.scrollOff - 1);
            return true;
        }
        if (key == 264) {
            this.scrollOff = Mth.m_14045_((int)(this.scrollOff + 1), (int)0, (int)(this.filtered.size() - 3));
            return true;
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseY >= (double)this.y && mouseY <= (double)this.y1 && mouseX >= (double)this.x && mouseX <= (double)this.x1;
    }

    @Nullable
    protected final SimplePlayerEntry getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX > (double)this.x1) {
            return null;
        }
        int rel = Mth.m_14107_((double)(mouseY - (double)this.y));
        int ind = this.scrollOff + rel / 12;
        return rel >= 0 && ind < this.filtered.size() ? this.filtered.get(ind) : null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int size = this.filtered.size();
        this.renderScroller(poseStack, size);
        if (size != 0) {
            SimplePlayerEntry hovered = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
            int currentY = this.y;
            for (int i = 0; this.scrollOff + i < size && i < 3; ++i) {
                SimplePlayerEntry e = this.filtered.get(this.scrollOff + i);
                e.render(poseStack, this.scrollOff + i, this.x, currentY, 101, 12, mouseX, mouseY, Objects.equals(hovered, e), partialTicks);
                currentY += 12;
            }
        }
    }

    private void renderScroller(PoseStack poseStack, int size) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.PRESENT_BLOCK_GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int currentIndex = size + 1 - 3;
        if (currentIndex > 1) {
            int a = 36 - (17 + (currentIndex - 1) * 36 / currentIndex);
            int b = 1 + a / currentIndex + 36 / currentIndex;
            int scroll = Math.min(19, this.scrollOff * b);
            if (this.scrollOff == currentIndex - 1) {
                scroll = 19;
            }
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(this.x + 102), (int)(this.y + scroll), (int)0, (float)0.0f, (float)232.0f, (int)6, (int)17, (int)256, (int)256);
        } else {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(this.x + 102), (int)this.y, (int)0, (float)6.0f, (float)232.0f, (int)6, (int)17, (int)256, (int)256);
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput elementOutput) {
    }

    public void setState(boolean hasItem, boolean packed) {
        this.filtered.clear();
        if (!packed && hasItem) {
            this.filtered.addAll(this.allPlayers);
        }
    }

    public static class SimplePlayerEntry {
        private static final int SKIN_SIZE = 8;
        private final Font font;
        private final UUID id;
        private final String playerName;
        private final Supplier<ResourceLocation> skinGetter;

        public SimplePlayerEntry(PlayerInfo playerInfo, Font font) {
            this.id = playerInfo.m_105312_().getId();
            this.playerName = playerInfo.m_105312_().getName();
            this.skinGetter = () -> ((PlayerInfo)playerInfo).m_105337_();
            this.font = font;
        }

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.playerName;
        }

        public void render(PoseStack poseStack, int pIndex, int pLeft, int pTop, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean hovered, float pPartialTicks) {
            int i = pLeft + 2;
            int j = pTop + (pHeight - 8) / 2;
            int k = i + 8 + 2;
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.PRESENT_BLOCK_GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)pLeft, (int)pTop, (int)0, (float)0.0f, (float)220.0f, (int)pWidth, (int)pHeight, (int)256, (int)256);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.skinGetter.get());
            GuiComponent.m_93160_((PoseStack)poseStack, (int)i, (int)j, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69478_();
            GuiComponent.m_93160_((PoseStack)poseStack, (int)i, (int)j, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69461_();
            this.font.m_92883_(poseStack, this.playerName, (float)k, (float)j, hovered ? -1 : 0);
        }
    }
}

