/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.pickle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.pickle.PickleModel;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;

public class PickleRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PickleModel<AbstractClientPlayer>> {
    protected float axisFacing = 0.0f;
    protected boolean wasCrouching = false;

    public PickleRenderer(EntityRendererProvider.Context context) {
        super(context, new PickleModel(context.m_174023_(ClientRegistry.PICKLE_MODEL)), 0.0125f);
        this.f_114478_ = 0.0f;
        this.f_114477_ = 0.0f;
        this.m_115326_((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new PickleModel.PickleArmor(this, new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new PickleModel.PickleElytra(this, context.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer player) {
        return Textures.SEA_PICKLE_RICK;
    }

    protected boolean shouldShowName(AbstractClientPlayer player) {
        return !player.m_6047_() && super.m_6512_((LivingEntity)player);
    }

    protected void scale(AbstractClientPlayer player, PoseStack stack, float partialTickTime) {
        stack.m_85841_(0.5f, 0.5f, 0.5f);
    }

    public void render(AbstractClientPlayer player, float p_225623_2_, float partialTicks, PoseStack matrixStack, MultiBufferSource p_225623_5_, int p_225623_6_) {
        ((PickleModel)this.f_115290_).partialTicks = partialTicks;
        this.setModelProperties(player);
        if (this.wasCrouching) {
            float f = (Mth.m_14189_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) + this.axisFacing) % 360.0f;
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f));
        }
        super.m_7392_((LivingEntity)player, p_225623_2_, partialTicks, matrixStack, p_225623_5_, p_225623_6_);
    }

    public Vec3 getRenderOffset(AbstractClientPlayer player, float p_225627_2_) {
        return new Vec3(0.0, -0.25, 0.0);
    }

    private void setModelProperties(AbstractClientPlayer player) {
        PlayerModel playermodel = (PlayerModel)this.m_7200_();
        playermodel.m_8009_(false);
        boolean c = player.m_6047_();
        playermodel.f_102810_.f_104207_ = true;
        playermodel.f_102812_.f_104207_ = !c;
        playermodel.f_102811_.f_104207_ = !c;
        playermodel.f_102814_.f_104207_ = !c;
        playermodel.f_102813_.f_104207_ = !c;
        playermodel.f_102808_.f_104207_ = !c;
        boolean bl = playermodel.f_102809_.f_104207_ = !c;
        if (this.wasCrouching != c && c) {
            this.axisFacing = -player.m_6350_().m_122435_();
        }
        this.wasCrouching = c;
        HumanoidModel.ArmPose poseRightArm = PickleRenderer.getArmPose(player, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose poseLeftArm = PickleRenderer.getArmPose(player, InteractionHand.OFF_HAND);
        if (poseRightArm.m_102897_()) {
            HumanoidModel.ArmPose armPose = poseLeftArm = player.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (player.m_5737_() == HumanoidArm.RIGHT) {
            playermodel.f_102816_ = poseRightArm;
            playermodel.f_102815_ = poseLeftArm;
        } else {
            playermodel.f_102816_ = poseLeftArm;
            playermodel.f_102815_ = poseRightArm;
        }
    }

    protected static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.m_7655_() == hand && player.m_21212_() > 0) {
            UseAnim useAnimation = itemstack.m_41780_();
            if (useAnimation == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAnimation == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAnimation == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAnimation == UseAnim.CROSSBOW && hand == player.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAnimation == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!player.f_20911_ && itemstack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void renderNameTag(AbstractClientPlayer player, Component name, PoseStack matrixStack, MultiBufferSource buffer, int p_225629_5_) {
        Scoreboard scoreboard;
        Objective objective;
        double d0 = this.f_114476_.m_114471_((Entity)player);
        matrixStack.m_85836_();
        if (d0 < 100.0 && (objective = (scoreboard = player.m_36329_()).m_83416_(2)) != null) {
            Score score = scoreboard.m_83471_(player.m_6302_(), objective);
            super.m_7649_((Entity)player, (Component)new TextComponent(Integer.toString(score.m_83400_())).m_130946_(" ").m_7220_(objective.m_83322_()), matrixStack, buffer, p_225629_5_);
            matrixStack.m_85837_(0.0, (double)0.25875f, 0.0);
        }
        super.m_7649_((Entity)player, name, matrixStack, buffer, p_225629_5_);
        matrixStack.m_85849_();
    }

    protected void setupRotations(AbstractClientPlayer player, PoseStack matrixStack, float p_225621_3_, float p_225621_4_, float partialTicks) {
        float f = player.m_20998_(partialTicks);
        if (player.m_21255_()) {
            super.m_7523_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, partialTicks);
            float f1 = (float)player.m_21256_() + partialTicks;
            float inclination = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.m_21209_()) {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(inclination * (-90.0f - player.m_146909_())));
            }
            Vec3 vector3d = player.m_20252_(partialTicks);
            Vec3 vector3d1 = player.m_20184_();
            double d0 = vector3d1.m_165925_();
            double d1 = vector3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                matrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, partialTicks);
            float f3 = player.m_20069_() ? -90.0f - player.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            if (player.m_6067_()) {
                matrixStack.m_85837_(0.0, -0.25, 0.25);
            }
        } else {
            super.m_7523_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, partialTicks);
        }
    }
}

