/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.api.ISoapWashable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class BlackboardBlock
extends WaterBlock
implements EntityBlock,
ISoapWashable {
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public BlackboardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile tile = (BlackboardBlockTile)blockEntity;
            BlockUtils.addOptionalOwnership(placer, tile);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    private static byte colorToByte(DyeColor color) {
        return switch (color) {
            case DyeColor.BLACK -> 0;
            case DyeColor.WHITE -> 1;
            case DyeColor.ORANGE -> 15;
            default -> (byte)color.m_41060_();
        };
    }

    public static int colorFromByte(byte b) {
        return switch (b) {
            case 0, 1 -> 0xFFFFFF;
            case 15 -> DyeColor.ORANGE.m_41069_().f_76396_;
            default -> DyeColor.m_41053_((int)b).m_41069_().f_76396_;
        };
    }

    public static Pair<Integer, Integer> getHitSubPixel(BlockHitResult hit) {
        Vec3 v2 = hit.m_82450_();
        Vec3 v = v2.m_82524_((float)((double)hit.m_82434_().m_122435_() * Math.PI / 180.0));
        double fx = v.f_82479_ % 1.0 * 16.0;
        if (fx < 0.0) {
            fx += 16.0;
        }
        int x = Mth.m_14045_((int)((int)fx), (int)-15, (int)15);
        int y = 15 - (int)Mth.m_14008_((double)Math.abs(v.f_82480_ % 1.0 * 16.0), (double)0.0, (double)15.0);
        return new Pair((Object)x, (Object)y);
    }

    @Nullable
    public static DyeColor getStackChalkColor(ItemStack stack) {
        Item item2 = stack.m_41720_();
        DyeColor color = null;
        if (ServerConfigs.cached.BLACKBOARD_COLOR) {
            color = item2.getRegistryName().m_135827_().equals("chalk") ? DyeColor.m_41057_((String)item2.getRegistryName().m_135815_().replace("_chalk", ""), (DyeColor)DyeColor.WHITE) : DyeColor.getColor((ItemStack)stack);
        }
        if (color == null) {
            if (stack.m_150922_(ModTags.CHALK) || stack.m_150922_((Tag)Tags.Items.DYES_WHITE)) {
                color = DyeColor.WHITE;
            } else if (item2 == Items.f_42413_ || item2 == Items.f_42414_ || stack.m_150922_((Tag)Tags.Items.DYES_BLACK)) {
                color = DyeColor.BLACK;
            }
        }
        return color;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            if (hit.m_82434_() == state.m_61143_((Property)FACING)) {
                ItemStack stack = player.m_21120_(handIn);
                Pair<Integer, Integer> pair = BlackboardBlock.getHitSubPixel(hit);
                int x = (Integer)pair.getFirst();
                int y = (Integer)pair.getSecond();
                DyeColor color = BlackboardBlock.getStackChalkColor(stack);
                if (color != null) {
                    byte newColor = BlackboardBlock.colorToByte(color);
                    if (te.getPixel(x, y) != newColor) {
                        te.setPixel(x, y, newColor);
                        te.m_6596_();
                    }
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
            }
            if (!worldIn.f_46443_) {
                te.sendOpenGuiPacket(worldIn, pos, player);
            }
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BlackboardBlockTile(pPos, pState);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            tooltip.add((Component)new TranslatableComponent("message.supplementaries.blackboard").m_130940_(ChatFormatting.GRAY));
        }
    }

    public ItemStack getBlackboardItem(BlackboardBlockTile te) {
        CompoundTag tag;
        ItemStack itemstack = new ItemStack((ItemLike)this);
        if (!te.isEmpty() && !(tag = te.savePixels(new CompoundTag())).m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (net.minecraft.nbt.Tag)tag);
        }
        return itemstack;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            return this.getBlackboardItem(te);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    @Override
    public boolean tryWash(Level level, BlockPos pos, BlockState state) {
        BlackboardBlockTile te;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile && !(te = (BlackboardBlockTile)blockEntity).isEmpty()) {
            te.clear();
            return true;
        }
        return false;
    }
}

