/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrankBlock
extends WaterBlock {
    protected static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)2.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)5.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)5.0, (double)14.0, (double)14.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)11.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public CrankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing.m_122424_() == stateIn.m_61143_((Property)FACING) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return CrankBlock.m_49863_((LevelReader)worldIn, (BlockPos)blockpos, (Direction)direction);
        }
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, direction);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockPos behind;
        BlockState backState;
        if (worldIn.f_46443_) {
            Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            double d0 = (double)pos.m_123341_() + 0.5 + 0.1 * (double)direction.m_122429_() + 0.2 * (double)direction.m_122429_();
            double d1 = (double)pos.m_123342_() + 0.5 + 0.1 * (double)direction.m_122430_() + 0.2 * (double)direction.m_122430_();
            double d2 = (double)pos.m_123343_() + 0.5 + 0.1 * (double)direction.m_122431_() + 0.2 * (double)direction.m_122431_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        boolean ccw = player.m_6144_();
        this.activate(state, worldIn, pos, ccw);
        float f = 0.4f;
        worldIn.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
        worldIn.m_142346_((Entity)player, GameEvent.f_157799_, pos);
        Direction dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        if (dir.m_122434_() != Direction.Axis.Y && (backState = worldIn.m_8055_(behind = pos.m_142300_(dir))).m_60713_((Block)ModRegistry.PULLEY_BLOCK.get()) && dir.m_122434_() == backState.m_61143_((Property)PulleyBlock.f_55923_)) {
            ((PulleyBlock)backState.m_60734_()).windPulley(backState, behind, (LevelAccessor)worldIn, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, dir);
        }
        return InteractionResult.CONSUME;
    }

    public void activate(BlockState state, Level world, BlockPos pos, boolean ccw) {
        state = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf((16 + (Integer)state.m_61143_((Property)POWER) + (ccw ? -1 : 1)) % 16));
        world.m_7731_(pos, state, 3);
        this.updateNeighbors(state, world, pos);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.m_61143_((Property)FACING) == side ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), (Block)this);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            if ((Integer)state.m_61143_((Property)POWER) != 0) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.m_61143_((Property)POWER) > 0 && rand.nextFloat() < 0.25f) {
            Direction direction = ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_();
            double d0 = (double)pos.m_123341_() + 0.5 + 0.1 * (double)direction.m_122429_() + 0.2 * (double)direction.m_122429_();
            double d1 = (double)pos.m_123342_() + 0.5 + 0.1 * (double)direction.m_122430_() + 0.2 * (double)direction.m_122430_();
            double d2 = (double)pos.m_123343_() + 0.5 + 0.1 * (double)direction.m_122431_() + 0.2 * (double)direction.m_122431_();
            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(DustParticleOptions.f_175788_, 0.5f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_5568_() {
        return true;
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity2) {
        return BlockPathTypes.OPEN;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType pathType) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState blockstate = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : directions = context.m_6232_()) {
            Direction direction1 = direction.m_122424_();
            if (!(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)direction1)).m_60710_((LevelReader)level, blockpos)) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }
}

