/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.selene.map.ExpandedMapData;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IColored;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlagBlock
extends WaterBlock
implements EntityBlock,
IColored {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final Map<DyeColor, Block> BY_COLOR = Maps.newHashMap();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final DyeColor color;

    public FlagBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        BY_COLOR.put(color, (Block)this);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemStack;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FlagBlockTile) {
            FlagBlockTile tile = (FlagBlockTile)blockEntity;
            itemStack = tile.getItem(state);
        } else {
            itemStack = super.getCloneItemStack(state, target, world, pos, player);
        }
        return itemStack;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public static Block byColor(DyeColor color) {
        return BY_COLOR.getOrDefault(color, Blocks.f_50414_);
    }

    public boolean m_5568_() {
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FlagBlockTile(pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity2, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof FlagBlockTile) {
            FlagBlockTile tile = (FlagBlockTile)blockEntity;
            tile.setCustomName(stack.m_41786_());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FlagBlockTile) {
            FlagBlockTile tile = (FlagBlockTile)blockEntity;
            ItemStack itemstack = player.m_21120_(hand);
            if (itemstack.m_41720_() instanceof MapItem) {
                MapItemSavedData mapItemSavedData;
                if (!world.f_46443_ && (mapItemSavedData = MapItem.m_42853_((ItemStack)itemstack, (Level)world)) instanceof ExpandedMapData) {
                    ExpandedMapData data = (ExpandedMapData)mapItemSavedData;
                    data.toggleCustomDecoration((LevelAccessor)world, pos);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND && ServerConfigs.cached.STICK_POLE) {
                if (world.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                Direction moveDir = player.m_6144_() ? Direction.DOWN : Direction.UP;
                StickBlock.findConnectedFlag(world, pos.m_7495_(), Direction.UP, moveDir, 0);
                StickBlock.findConnectedFlag(world, pos.m_7494_(), Direction.DOWN, moveDir, 0);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }
}

