/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IColored;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PresentBlock
extends WaterBlock
implements EntityBlock,
IColored {
    public static final BooleanProperty PACKED = BlockProperties.PACKED;
    private final DyeColor color;
    public static final VoxelShape SHAPE_OPEN = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    public static final VoxelShape SHAPE_CLOSED = Shapes.m_83110_((VoxelShape)SHAPE_OPEN, (VoxelShape)Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0));

    public PresentBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PACKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PACKED, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PresentBlockTile(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof PresentBlockTile) {
            PresentBlockTile tile = (PresentBlockTile)blockEntity;
            return tile.interact((ServerPlayer)player, pos);
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof PresentBlockTile) {
            PresentBlockTile tile = (PresentBlockTile)blockEntity;
            if (!worldIn.f_46443_ && player.m_7500_() && !tile.m_7983_()) {
                ItemStack itemstack = tile.getPresentItem((ItemLike)this);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                worldIn.m_7967_((Entity)itementity);
            } else {
                tile.m_59640_(player);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof PresentBlockTile) {
            PresentBlockTile tile = (PresentBlockTile)object;
            ItemStack itemstack = tile.getPresentItem((ItemLike)this);
            return Collections.singletonList(itemstack);
        }
        return super.m_7381_(state, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemstack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PresentBlockTile) {
            PresentBlockTile tile = (PresentBlockTile)blockEntity;
            return tile.getPresentItem((ItemLike)this);
        }
        return itemstack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof PresentBlockTile) {
            PresentBlockTile tile = (PresentBlockTile)blockEntity;
            tile.m_58638_(stack.m_41786_());
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)PACKED)).booleanValue()) {
            return SHAPE_CLOSED;
        }
        return SHAPE_OPEN;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            worldIn.m_46717_(pos, state.m_60734_());
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        return blockEntity instanceof MenuProvider ? (MenuProvider)blockEntity : null;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        CompoundTag t;
        BlockState state = super.m_5573_(context);
        CompoundTag tag = context.m_43722_().m_41783_();
        if (tag != null && tag.m_128441_("BlockEntityTag") && (t = tag.m_128469_("BlockEntityTag")).m_128441_("Items")) {
            state = (BlockState)state.m_61124_((Property)PACKED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

