/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.client.gui.BlackBoardGui;
import net.mehvahdjukaar.supplementaries.client.gui.IScreenProvider;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class BlackboardBlockTile
extends BlockEntity
implements IOwnerProtected,
IScreenProvider {
    public static final ModelProperty<BlackboardTextureManager.BlackboardKey> BLACKBOARD = BlockProperties.BLACKBOARD;
    private UUID owner = null;
    private byte[][] pixels = new byte[16][16];
    private BlackboardTextureManager.BlackboardKey textureKey = null;

    public BlackboardBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.BLACKBOARD_TILE.get(), pos, state);
        this.clear();
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BLACKBOARD, (Object)this.getTextureKey()).build();
    }

    public BlackboardTextureManager.BlackboardKey getTextureKey() {
        if (this.textureKey == null) {
            this.refreshTexture();
        }
        return this.textureKey;
    }

    public void refreshTexture() {
        this.textureKey = new BlackboardTextureManager.BlackboardKey(this.pixels);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.refreshTexture();
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public void m_6596_() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromTag(compound);
        this.loadOwner(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.savePixels(compound);
        this.saveOwner(compound);
    }

    public CompoundTag savePixels(CompoundTag compound) {
        compound.m_128388_("Pixels", BlackboardBlockTile.packPixels(this.pixels));
        return compound;
    }

    public void loadFromTag(CompoundTag compound) {
        this.pixels = new byte[16][16];
        if (compound.m_128441_("Pixels")) {
            this.pixels = BlackboardBlockTile.unpackPixels(compound.m_128467_("Pixels"));
        }
    }

    public static long[] packPixels(byte[][] pixels) {
        long[] packed = new long[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            long l = 0L;
            for (int j = 0; j < pixels[i].length; ++j) {
                l |= (long)(pixels[i][j] & 0xF) << j * 4;
            }
            packed[i] = l;
        }
        return packed;
    }

    public static byte[][] unpackPixels(long[] packed) {
        byte[][] bytes = new byte[16][16];
        for (int i = 0; i < packed.length; ++i) {
            for (int j = 0; j < 16; ++j) {
                bytes[i][j] = (byte)(packed[i] >> j * 4 & 0xFL);
            }
        }
        return bytes;
    }

    public void clear() {
        for (int x = 0; x < this.pixels.length; ++x) {
            for (int y = 0; y < this.pixels[x].length; ++y) {
                this.pixels[x][y] = 0;
            }
        }
    }

    public boolean isEmpty() {
        boolean flag = false;
        byte[][] byArray = this.pixels;
        int n = byArray.length;
        block0: for (int i = 0; i < n; ++i) {
            byte[] pixel;
            for (byte b : pixel = byArray[i]) {
                if (b == 0) continue;
                flag = true;
                continue block0;
            }
        }
        return !flag;
    }

    public void setPixel(int x, int y, byte b) {
        this.pixels[x][y] = b;
    }

    public byte getPixel(int xx, int yy) {
        return this.pixels[xx][yy];
    }

    public void setPixels(byte[][] pixels) {
        this.pixels = pixels;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)NoticeBoardBlock.FACING);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public void openScreen(Level level, BlockPos pos, Player player) {
        BlackBoardGui.open(this);
    }
}

