/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeKnotBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.utils.BlockItemUtils;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class RopeArrowEntity
extends AbstractArrow {
    private int charges = 0;
    private BlockPos prevPlacedPos = null;

    public RopeArrowEntity(EntityType<? extends RopeArrowEntity> type, Level world) {
        super(type, world);
    }

    public RopeArrowEntity(Level worldIn, LivingEntity throwerIn, int charges) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), throwerIn, worldIn);
        this.charges = charges;
    }

    public RopeArrowEntity(Level worldIn, double x, double y, double z, int charges) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), x, y, z, worldIn);
        this.charges = charges;
    }

    public RopeArrowEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), x, y, z, worldIn);
    }

    public RopeArrowEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Ropes", this.charges);
        if (this.prevPlacedPos != null) {
            compound.m_128365_("PrevPlacedPos", (Tag)NbtUtils.m_129224_((BlockPos)this.prevPlacedPos));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.charges = compound.m_128451_("Ropes");
        if (compound.m_128441_("PrevPlacedPos")) {
            this.prevPlacedPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("PrevPlacedPos"));
        }
    }

    protected ItemStack m_7941_() {
        if (this.charges != 0) {
            ItemStack stack = new ItemStack((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get());
            stack.m_41721_(stack.m_41776_() - this.charges);
            return stack;
        }
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    protected void m_8060_(BlockHitResult rayTraceResult) {
        super.m_8060_(rayTraceResult);
        Block ropeBlock = ServerConfigs.cached.ROPE_ARROW_BLOCK;
        if (this.charges <= 0) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            this.prevPlacedPos = null;
            Entity entity2 = this.m_37282_();
            Player player = null;
            if (!(entity2 instanceof Mob) || this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) || ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                BlockState state;
                BlockState knotState;
                BlockProperties.PostType knotType;
                if (entity2 instanceof Player && ((Player)entity2).m_36326_()) {
                    player = (Player)entity2;
                }
                BlockPos hitPos = rayTraceResult.m_82425_();
                BlockState hitState = this.f_19853_.m_8055_(hitPos);
                Block hitBlock = hitState.m_60734_();
                if (ServerConfigs.cached.ROPE_ARROW_BLOCK == ModRegistry.ROPE.get() && (knotType = BlockProperties.PostType.get(hitState)) != null && (knotState = RopeKnotBlock.convertToRopeKnot(knotType, hitState, this.f_19853_, hitPos)) != null) {
                    this.prevPlacedPos = ((Direction.Axis)knotState.m_61143_(RopeKnotBlock.AXIS)).m_122478_() ? hitPos.m_142300_(rayTraceResult.m_82434_()).m_7494_() : hitPos;
                    this.removeCharge();
                    return;
                }
                if (hitBlock == ropeBlock && RopeBlock.addRope(hitPos, this.f_19853_, player, InteractionHand.MAIN_HAND, ropeBlock)) {
                    this.prevPlacedPos = hitPos;
                    this.removeCharge();
                    return;
                }
                hitBlock = this.f_19853_.m_8055_(hitPos = hitPos.m_142300_(rayTraceResult.m_82434_())).m_60734_();
                if (hitBlock == ropeBlock && RopeBlock.addRope(hitPos, this.f_19853_, player, InteractionHand.MAIN_HAND, ropeBlock)) {
                    this.prevPlacedPos = hitPos;
                    this.removeCharge();
                    return;
                }
                ItemStack ropes = new ItemStack((ItemLike)ropeBlock);
                BlockPlaceContext context = new BlockPlaceContext(this.f_19853_, (Player)entity2, InteractionHand.MAIN_HAND, ropes, rayTraceResult);
                if (context.m_7059_() && (state = BlockItemUtils.getPlacementState(context, ropeBlock)) != null) {
                    this.f_19853_.m_7731_(context.m_8083_(), state, 11);
                    this.prevPlacedPos = context.m_8083_();
                    this.removeCharge();
                }
            }
        }
    }

    private void removeCharge() {
        this.charges = Math.max(0, this.charges - 1);
        this.f_19853_.m_5594_(null, this.prevPlacedPos, SoundEvents.f_12087_, SoundSource.BLOCKS, 0.2f, 1.7f);
    }

    private void continueUnwindingRope() {
        BlockPos hitPos;
        Block ropeBlock = ServerConfigs.cached.ROPE_ARROW_BLOCK;
        Player player = null;
        Entity entity2 = this.m_37282_();
        if (entity2 instanceof Player && ((Player)entity2).m_36326_()) {
            player = (Player)entity2;
        }
        if (RopeBlock.addRope((hitPos = this.prevPlacedPos).m_7495_(), this.f_19853_, player, InteractionHand.MAIN_HAND, ropeBlock)) {
            this.prevPlacedPos = hitPos.m_7495_();
            this.removeCharge();
        } else {
            this.prevPlacedPos = null;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.charges != 0 && this.prevPlacedPos != null) {
            this.continueUnwindingRope();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity2 = pResult.m_82443_();
        int k = entity2.m_20094_();
        if (this.m_6060_() && entity2.m_6095_() != EntityType.f_20566_) {
            entity2.m_20254_(5);
        }
        entity2.m_7311_(k);
        this.m_20256_(this.m_20184_().m_82490_(-0.1));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
        if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
            if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                this.m_5552_(this.m_7941_(), 0.1f);
            }
            this.m_146870_();
        }
    }

    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_ && entityIn.m_150109_().m_36054_(this.m_7941_())) {
            entityIn.m_7938_((Entity)this, 1);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

