/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSendBombKnockbackPacket
implements NetworkHandler.Message {
    private final double knockbackX;
    private final double knockbackY;
    private final double knockbackZ;

    public ClientBoundSendBombKnockbackPacket(Vec3 knockback) {
        this.knockbackX = knockback.f_82479_;
        this.knockbackY = knockback.f_82480_;
        this.knockbackZ = knockback.f_82481_;
    }

    public static void buffer(ClientBoundSendBombKnockbackPacket pkt, FriendlyByteBuf buf) {
        buf.writeDouble(pkt.knockbackX);
        buf.writeDouble(pkt.knockbackY);
        buf.writeDouble(pkt.knockbackZ);
    }

    public ClientBoundSendBombKnockbackPacket(FriendlyByteBuf buf) {
        this.knockbackX = buf.readDouble();
        this.knockbackY = buf.readDouble();
        this.knockbackZ = buf.readDouble();
    }

    public static void handler(ClientBoundSendBombKnockbackPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ClientReceivers.handleSendBombKnockbackPacket(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public double getKnockbackX() {
        return this.knockbackX;
    }

    public double getKnockbackY() {
        return this.knockbackY;
    }

    public double getKnockbackZ() {
        return this.knockbackZ;
    }
}

