/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.data.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.markers.NamedMapWorldMarker;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.common.world.data.map.CMDreg;
import net.mehvahdjukaar.supplementaries.common.world.data.map.ColoredDecoration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FlagMarker
extends NamedMapWorldMarker<ColoredDecoration> {
    private DyeColor color;

    public FlagMarker() {
        super(CMDreg.FLAG_DECORATION_TYPE);
    }

    public FlagMarker(BlockPos pos, DyeColor color, @Nullable Component name) {
        this();
        this.pos = pos;
        this.color = color;
        this.name = name;
    }

    public CompoundTag saveToNBT(CompoundTag compoundnbt) {
        super.saveToNBT(compoundnbt);
        compoundnbt.m_128359_("Color", this.color.m_41065_());
        return compoundnbt;
    }

    public void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.color = DyeColor.m_41057_((String)compound.m_128461_("Color"), (DyeColor)DyeColor.WHITE);
    }

    @Nullable
    public static FlagMarker getFromWorld(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FlagBlockTile) {
            FlagBlockTile tile = (FlagBlockTile)blockEntity;
            DyeColor dyecolor = tile.getColor();
            Component name = tile.m_8077_() ? tile.m_7770_() : null;
            return new FlagMarker(pos, dyecolor, name);
        }
        return null;
    }

    @Nullable
    public ColoredDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new ColoredDecoration(this.getType(), mapX, mapY, rot, this.name, this.color);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && ((Object)((Object)this)).getClass() == other.getClass()) {
            FlagMarker marker = (FlagMarker)((Object)other);
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.color);
    }
}

