/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.explosion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendBombKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BombExplosion
extends Explosion {
    private final Entity source;
    private final float radius;
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final BombEntity.BombType bombType;
    private final ExplosionDamageCalculator damageCalculator;
    private final List<BlockPos> toBlow = Lists.newArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    private final Explosion.BlockInteraction mode;
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();

    public BombExplosion(Level world, @Nullable Entity entity2, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float radius, BombEntity.BombType bombType, Explosion.BlockInteraction interaction) {
        super(world, entity2, damageSource, context, x, y, z, radius, false, interaction);
        this.level = world;
        this.source = entity2;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.bombType = bombType;
        this.mode = interaction;
        this.damageCalculator = context == null ? this.makeDamageCalculator(entity2) : context;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity p_234894_1_) {
        return p_234894_1_ == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(p_234894_1_);
    }

    public void doFinalizeExplosion() {
        this.level.m_6263_(null, this.x, this.y, this.z, (SoundEvent)ModRegistry.BOMB_SOUND.get(), SoundSource.NEUTRAL, this.bombType.volume(), 1.2f + (this.level.f_46441_.nextFloat() - this.level.f_46441_.nextFloat()) * 0.2f);
        ObjectArrayList drops = new ObjectArrayList();
        Collections.shuffle(this.toBlow, this.level.f_46441_);
        for (BlockPos blockpos : this.toBlow) {
            BlockState blockstate = this.level.m_8055_(blockpos);
            if (blockstate.m_60795_()) continue;
            BlockPos immutable = blockpos.m_7949_();
            this.level.m_46473_().m_6180_("explosion_blocks");
            if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && this.level instanceof ServerLevel) {
                BlockEntity blockEntity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.level).m_78977_(this.level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockEntity).m_78984_(LootContextParams.f_81455_, (Object)this.source);
                if (this.mode == Explosion.BlockInteraction.DESTROY) {
                    builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                }
                blockstate.m_60724_(builder).forEach(p_229977_2_ -> this.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)drops, (ItemStack)p_229977_2_, immutable));
            }
            blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
            this.level.m_46473_().m_7238_();
        }
        for (Pair pair : drops) {
            Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        int i = drops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)drops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemStack = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            drops.set(j, (Object)Pair.of((Object)itemStack, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void m_46061_() {
        this.level.m_142346_(this.source, GameEvent.f_157812_, new BlockPos(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        int i = 16;
        if (this.mode != Explosion.BlockInteraction.NONE) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.x;
                        double d6 = this.y;
                        double d8 = this.z;
                        float f1 = 0.3f;
                        for (float f = this.radius * (0.7f + this.level.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            FluidState fluidstate;
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            BlockState blockstate = this.level.m_8055_(blockpos);
                            Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate = this.level.m_6425_(blockpos));
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
        }
        this.toBlow.addAll(set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);
        for (Entity entity2 : list) {
            double d9;
            double d7;
            double d5;
            double d13;
            double distSq;
            double d12;
            if (entity2.m_6128_() || !((d12 = (double)(Mth.m_14116_((float)((float)(distSq = entity2.m_20238_(vector3d)))) / f2)) <= 1.0) || (d13 = (double)Mth.m_14116_((float)((float)((d5 = entity2.m_20185_() - this.x) * d5 + (d7 = (entity2 instanceof PrimedTnt ? entity2.m_20186_() : entity2.m_20188_()) - this.y) * d7 + (d9 = entity2.m_20189_() - this.z) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = BombExplosion.m_46064_((Vec3)vector3d, (Entity)entity2);
            double d10 = (1.0 - d12) * d14;
            entity2.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            double d11 = d10;
            boolean isPlayer = entity2 instanceof Player;
            Player playerentity = null;
            if (!(!isPlayer || (playerentity = (Player)entity2).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_)) {
                this.hitPlayers.put(playerentity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                if (!isPlayer || !playerentity.m_5833_() && !playerentity.m_7500_()) {
                    this.bombType.applyStatusEffects(livingEntity, distSq);
                }
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity2), (double)d10);
            }
            entity2.m_20256_(entity2.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
        }
        if (!this.level.f_46443_) {
            for (Player player : this.hitPlayers.keySet()) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundSendBombKnockbackPacket(this.hitPlayers.get(player)));
            }
        }
    }
}

