/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.util.Optional;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.entities.RedMerchantEntity;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class RedMerchantSpawnerMixin {
    @Shadow
    private int f_35911_;
    @Shadow
    private int f_35910_;
    @Final
    @Shadow
    private Random f_35908_;
    @Final
    @Shadow
    private ServerLevelData f_35909_;
    private int redSpawnDelay = 0;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(ServerLevel p_230253_1_, boolean p_230253_2_, boolean p_230253_3_, CallbackInfoReturnable<Integer> cir) {
        if (this.redSpawnDelay > 0) {
            --this.redSpawnDelay;
        }
    }

    @Inject(method={"spawn"}, at={@At(value="RETURN")}, cancellable=true)
    public void spawn(ServerLevel world, CallbackInfoReturnable<Boolean> cir) {
        RedMerchantEntity trader;
        PoiManager poiManager;
        Optional optional;
        BlockPos targetPos;
        BlockPos spawnPos;
        BlockPos blockpos;
        ServerPlayer player;
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.redSpawnDelay == 0 && (player = world.m_8890_()) != null && this.f_35908_.nextInt(9) == 0 && this.calculateNormalizeDifficulty(world, blockpos = player.m_142538_()) > this.f_35908_.nextFloat() * 90.0f && (spawnPos = this.m_35928_((LevelReader)world, targetPos = (optional = (poiManager = world.m_8904_()).m_27186_(PoiType.f_27347_.m_27392_(), p_221241_0_ -> true, blockpos, 48, PoiManager.Occupancy.ANY)).orElse(blockpos), 48)) != null && this.m_35925_((BlockGetter)world, spawnPos) && !world.m_45837_(spawnPos).equals(Optional.of(Biomes.f_48173_)) && (trader = (RedMerchantEntity)((EntityType)ModRegistry.RED_MERCHANT.get()).m_20600_(world, null, null, null, spawnPos, MobSpawnType.EVENT, false, false)) != null) {
            this.f_35909_.m_8115_(trader.m_142081_());
            int lifetime = 25000;
            trader.setDespawnDelay(lifetime);
            trader.setWanderTarget(targetPos);
            trader.m_21446_(targetPos, 16);
            this.redSpawnDelay = lifetime;
        }
    }

    private float calculateNormalizeDifficulty(ServerLevel world, BlockPos pos) {
        float dragon = 1.0f;
        CompoundTag tag = world.m_142572_().m_129910_().m_6564_();
        if (tag.m_128425_("DragonKilled", 99) && tag.m_128471_("DragonKilled")) {
            dragon = 1.25f;
        }
        long i = 0L;
        float f = 0.0f;
        if (world.m_46805_(pos)) {
            f = world.m_46940_();
            i = world.m_46745_(pos).m_6319_();
        }
        DifficultyInstance instance = new DifficultyInstance(Difficulty.NORMAL, world.m_46468_(), i, f);
        float diff = instance.m_19056_();
        diff = (float)((double)diff - 1.5);
        diff *= 4.0f;
        float scale = switch (world.m_46791_()) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 1.0f;
            case Difficulty.EASY -> 1.25f;
            case Difficulty.NORMAL -> 1.5f;
            case Difficulty.HARD -> 1.75f;
        };
        diff *= scale;
        diff *= dragon;
        if (CommonUtil.FESTIVITY.isChristmas()) {
            diff *= 8.0f;
        }
        return diff;
    }

    @Shadow
    protected abstract boolean m_35925_(BlockGetter var1, BlockPos var2);

    @Shadow
    protected abstract BlockPos m_35928_(LevelReader var1, BlockPos var2, int var3);
}

