/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.Optional;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PancakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.common.items.SoapItem;
import net.mehvahdjukaar.supplementaries.common.utils.BlockItemUtils;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;

public class DispenserRegistry {
    public static void registerBehaviors() {
        boolean axe;
        boolean jar;
        if (!((Boolean)RegistryConfigs.reg.DISPENSERS.get()).booleanValue()) {
            return;
        }
        if (((Boolean)RegistryConfigs.reg.FODDER_ENABLED.get()).booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.FODDER.get()));
        }
        if (((Boolean)RegistryConfigs.reg.BUBBLE_BLOWER_ENABLED.get()).booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.BUBBLE_BLOCK.get()));
        }
        if (jar = ((Boolean)RegistryConfigs.reg.JAR_ENABLED.get()).booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.JAR_ITEM.get()));
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.JAR_TINTED.get()));
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new DispenserHelper.AddItemToInventoryBehavior(Items.f_42572_));
        }
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FlintAndSteelDispenserBehavior(Items.f_42409_));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new BambooSpikesDispenserBehavior(Items.f_42739_));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new PancakesDispenserBehavior(Items.f_42787_));
        if (ServerConfigs.cached.THROWABLE_BRICKS_ENABLED) {
            for (Item i : ModTags.BRICKS.m_6497_()) {
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new ThrowableBricksDispenserBehavior(i));
            }
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_ITEM.get()), (DispenseItemBehavior)new BombsDispenserBehavior(BombEntity.BombType.NORMAL));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_ITEM_ON.get()), (DispenseItemBehavior)new BombsDispenserBehavior(BombEntity.BombType.NORMAL));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_BLUE_ITEM.get()), (DispenseItemBehavior)new BombsDispenserBehavior(BombEntity.BombType.BLUE));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_BLUE_ITEM_ON.get()), (DispenseItemBehavior)new BombsDispenserBehavior(BombEntity.BombType.BLUE));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_SPIKY_ITEM.get()), (DispenseItemBehavior)new BombsDispenserBehavior(BombEntity.BombType.SPIKY));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_SPIKY_ITEM_ON.get()), (DispenseItemBehavior)new BombsDispenserBehavior(BombEntity.BombType.SPIKY));
        }
        if (ServerConfigs.cached.PLACEABLE_GUNPOWDER) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new GunpowderBehavior(Items.f_42403_));
        }
        if (((Boolean)RegistryConfigs.reg.ROPE_ARROW_ENABLED.get()).booleanValue()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                    CompoundTag com = stack.m_41783_();
                    int charges = stack.m_41776_();
                    if (com != null && com.m_128441_("Damage")) {
                        charges -= com.m_128451_("Damage");
                    }
                    RopeArrowEntity arrow = new RopeArrowEntity(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), charges);
                    arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    return arrow;
                }
            });
        }
        if (((Boolean)RegistryConfigs.reg.SOAP_ENABLED.get()).booleanValue()) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new SoapBehavior((Item)ModRegistry.SOAP.get()));
        }
        if ((axe = ((Boolean)ServerConfigs.tweaks.AXE_DISPENSER_BEHAVIORS.get()).booleanValue()) || jar) {
            for (Item i : ForgeRegistries.ITEMS) {
                try {
                    if (jar && BucketHelper.isFishBucket(i)) {
                        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FishBucketJarDispenserBehavior(i));
                    }
                    if (!axe || !(i instanceof AxeItem)) continue;
                    DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new AxeDispenserBehavior(i));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("Error white registering dispenser behavior for item {}: {}", (Object)i, (Object)e);
                }
            }
        }
    }

    private static class FlintAndSteelDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FlintAndSteelDispenserBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            Block block2 = state.m_60734_();
            if (block2 instanceof ILightable) {
                ILightable block3 = (ILightable)block2;
                if (block3.lightUp(null, state, blockpos, (LevelAccessor)world, ILightable.FireSound.FLINT_AND_STEEL)) {
                    if (stack.m_41629_(1, world.f_46441_, null)) {
                        stack.m_41764_(0);
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class BambooSpikesDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected BambooSpikesDispenserBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (state.m_60734_() instanceof BambooSpikesBlock) {
                if (BambooSpikesBlock.tryAddingPotion(state, (LevelAccessor)world, blockpos, stack)) {
                    return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)Items.f_42590_));
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class PancakesDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected PancakesDispenserBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            Block block2 = state.m_60734_();
            if (block2 instanceof PancakeBlock) {
                PancakeBlock block3 = (PancakeBlock)block2;
                if (block3.tryAcceptingFluid((Level)world, state, blockpos, SoftFluidRegistry.HONEY, null, 1)) {
                    return InteractionResultHolder.m_19096_((Object)new ItemStack((ItemLike)Items.f_42590_));
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class ThrowableBricksDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected ThrowableBricksDispenserBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            ServerLevel world = source.m_7727_();
            Position dispensePosition = DispenserBlock.m_52720_((BlockSource)source);
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            Projectile projectileEntity = this.getProjectileEntity((Level)world, dispensePosition, stack);
            projectileEntity.m_6686_((double)direction.m_122429_(), (double)((float)direction.m_122430_() + 0.1f), (double)direction.m_122431_(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
            world.m_7967_((Entity)projectileEntity);
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }

        protected void playSound(BlockSource source, boolean success) {
            source.m_7727_().m_6263_(null, source.m_7096_() + 0.5, source.m_7098_() + 0.5, source.m_7094_() + 0.5, SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (source.m_7727_().m_5822_().nextFloat() * 0.4f + 0.8f));
        }

        protected Projectile getProjectileEntity(Level worldIn, Position position, ItemStack stackIn) {
            return new ThrowableBrickEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
        }

        protected float getProjectileInaccuracy() {
            return 7.0f;
        }

        protected float getProjectileVelocity() {
            return 0.9f;
        }
    }

    private static class BombsDispenserBehavior
    extends AbstractProjectileDispenseBehavior {
        private final BombEntity.BombType type;

        public BombsDispenserBehavior(BombEntity.BombType blue) {
            this.type = blue;
        }

        protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            return new BombEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_(), this.type);
        }

        protected float m_7101_() {
            return 11.0f;
        }

        protected float m_7104_() {
            return 1.3f;
        }
    }

    public static class GunpowderBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected GunpowderBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos blockpos = source.m_7961_().m_142300_(direction);
            Direction direction1 = source.m_7727_().m_46859_(blockpos.m_7495_()) ? direction : Direction.UP;
            InteractionResult result = BlockItemUtils.place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.m_7727_(), blockpos, direction, stack, direction1), (Block)ModRegistry.GUNPOWDER_BLOCK.get());
            if (result.m_19077_()) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
    }

    private static class SoapBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected SoapBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos pos;
            ServerLevel level = source.m_7727_();
            if (SoapItem.tryCleaning(stack, (Level)level, pos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)), null)) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
    }

    private static class FishBucketJarDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FishBucketJarDispenserBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockEntity blockEntity = world.m_7702_(blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (blockEntity instanceof JarBlockTile) {
                JarBlockTile tile = (JarBlockTile)blockEntity;
                if (tile.fluidHolder.isEmpty() && tile.m_7983_() && tile.mobContainer.interactWithBucket(stack, (Level)world, blockpos, null, null)) {
                    tile.m_6596_();
                    return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    private static class AxeDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected AxeDispenserBehavior(Item item2) {
            super(item2);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos pos;
            ServerLevel level = source.m_7727_();
            BlockState state = level.m_8055_(pos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            Block b = state.m_60734_();
            Optional<BlockState> optional = Optional.ofNullable(b.getToolModifiedState(state, (Level)level, pos, null, stack, ToolActions.AXE_STRIP));
            if (optional.isPresent()) {
                level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, optional.get(), 11);
                if (stack.m_41629_(1, level.m_5822_(), null)) {
                    stack.m_41764_(0);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            optional = Optional.ofNullable(b.getToolModifiedState(state, (Level)level, pos, null, stack, ToolActions.AXE_SCRAPE));
            if (optional.isPresent()) {
                level.m_5594_(null, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(null, 3005, pos, 0);
                level.m_7731_(pos, optional.get(), 11);
                if (stack.m_41629_(1, level.m_5822_(), null)) {
                    stack.m_41764_(0);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            optional = Optional.ofNullable(b.getToolModifiedState(state, (Level)level, pos, null, stack, ToolActions.AXE_WAX_OFF));
            if (optional.isPresent()) {
                level.m_5594_(null, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(null, 3004, pos, 0);
                level.m_7731_(pos, optional.get(), 11);
                if (stack.m_41629_(1, level.m_5822_(), null)) {
                    stack.m_41764_(0);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
    }
}

