/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class FluidDummyModel
implements BakedModel {
    private final Fluid fluid;
    private final TextureAtlasSprite particles;
    private final Map<Direction, List<BakedQuad>> quads = new HashMap<Direction, List<BakedQuad>>();

    public FluidDummyModel(Fluid fluid) {
        this.fluid = fluid;
        Function spriteGetter = Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_);
        this.particles = (TextureAtlasSprite)spriteGetter.apply(fluid.getAttributes().getStillTexture());
        this.buildQuads(spriteGetter);
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.quads.get(side);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particles;
    }

    public ItemOverrides m_7343_() {
        return null;
    }

    private void buildQuads(Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite stillSprite = spriteGetter.apply(this.fluid.getAttributes().getStillTexture());
        TextureAtlasSprite flowingSprite = spriteGetter.apply(this.fluid.getAttributes().getFlowingTexture());
        for (Direction dir : Direction.values()) {
            boolean isX = dir.m_122434_() == Direction.Axis.X;
            boolean isY = dir.m_122434_() == Direction.Axis.Y;
            boolean isZ = dir.m_122434_() == Direction.Axis.Z;
            boolean isPos = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
            BakedQuadBuilder builder = new BakedQuadBuilder();
            builder.setQuadOrientation(dir);
            builder.setQuadTint(1);
            TextureAtlasSprite sprite = isY ? stillSprite : flowingSprite;
            builder.setTexture(sprite);
            for (int vert = 0; vert < 4; ++vert) {
                float z;
                float y;
                float x;
                float v;
                float u = vert >= 2 ? 0.5f : 0.0f;
                float f = v = vert == 0 || vert == 3 ? 0.0f : 0.5f;
                if (isY) {
                    x = vert == 0 || vert == 3 ? 1.0f : 0.0f;
                    y = isPos ? 1.0f : 0.0f;
                    z = vert >= 2 == isPos ? 1.0f : 0.0f;
                    u = vert == 0 || vert == 3 ? 0.0f : 1.0f;
                    v = vert >= 2 ? 1.0f : 0.0f;
                } else if (isX) {
                    x = isPos ? 1.0f : 0.0f;
                    y = vert == 0 || vert == 3 ? 1.0f : 0.0f;
                    z = vert < 2 == isPos ? 1.0f : 0.0f;
                } else if (isZ) {
                    x = vert >= 2 == isPos ? 1.0f : 0.0f;
                    y = vert == 0 || vert == 3 ? 1.0f : 0.0f;
                    z = isPos ? 1.0f : 0.0f;
                } else {
                    throw new IllegalArgumentException("Invalid dir!");
                }
                FluidDummyModel.putVertexData((IVertexConsumer)builder, new Vector4f(x, y, z, 1.0f), new Vec2(u, v), dir.m_122432_(), this.fluid.getAttributes().getColor(), new Vec2(240.0f, 240.0f), sprite);
            }
            this.quads.put(dir, Collections.singletonList(builder.build()));
        }
        this.quads.put(null, Collections.emptyList());
    }

    private static void putVertexData(IVertexConsumer consumer, Vector4f pos, Vec2 tex, Vector3f normal, int color, Vec2 light, TextureAtlasSprite texture) {
        ImmutableList elements = consumer.getVertexFormat().m_86023_();
        block10: for (int elem = 0; elem < elements.size(); ++elem) {
            VertexFormatElement e = (VertexFormatElement)elements.get(elem);
            switch (e.m_86048_()) {
                case POSITION: {
                    consumer.put(elem, new float[]{pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), pos.m_123617_()});
                    continue block10;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    consumer.put(elem, new float[]{r, g, b, a});
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            consumer.put(elem, new float[]{texture.m_118367_((double)(tex.f_82470_ * 16.0f)), texture.m_118393_((double)(tex.f_82471_ * 16.0f))});
                            continue block10;
                        }
                        case 2: {
                            consumer.put(elem, new float[]{light.f_82470_, light.f_82471_});
                            continue block10;
                        }
                    }
                    consumer.put(elem, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    consumer.put(elem, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                    continue block10;
                }
                default: {
                    consumer.put(elem, new float[0]);
                }
            }
        }
    }
}

