/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.common.data.LatchType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestLidModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_chest_lock");
    private final Direction facing;
    private final LatchType latch;

    public FramedChestLidModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        this.latch = (LatchType)((Object)state.m_61143_(PropertyHolder.LATCH_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0625f, 0.0625f, 0.9375f, 0.9375f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.875f : 0.4375f);
                quadMap.get(null).add(topBotQuad);
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0625f, 0.5625f, 0.9375f, 0.875f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.9375f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestModel.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return this.latch == LatchType.DEFAULT && layer == RenderType.m_110463_();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (!quad.m_173410_().m_118413_().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }
}

