/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public class FramedDoorModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean hingeRight;
    private final boolean open;

    public FramedDoorModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.hingeRight = state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.RIGHT;
        this.open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean facePositive;
        Direction faceDir = this.dir;
        if (this.open) {
            faceDir = this.hingeRight ? faceDir.m_122428_() : faceDir.m_122427_();
        }
        boolean bl = facePositive = faceDir.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, faceDir, 0.1875f)) {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
        } else if (quad.m_111306_() == faceDir) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, 0.1875f);
            quadMap.get(null).add(faceQuad);
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, !facePositive, 0.1875f)) {
                quadMap.get(quad.m_111306_()).add(sideQuad);
            }
        }
    }
}

