/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public class FramedLeverModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_block");
    private final Direction dir;
    private final AttachFace face;

    public FramedLeverModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)Blocks.f_50164_.m_49966_(), (RenderType)layer);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (quad.m_173410_().m_118413_().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction facing = this.dir;
        if (this.face == AttachFace.CEILING) {
            facing = Direction.DOWN;
        } else if (this.face == AttachFace.FLOOR) {
            facing = Direction.UP;
        }
        if (facing.m_122434_() == Direction.Axis.Y) {
            float maxZ;
            boolean rotX = this.dir.m_122434_() == Direction.Axis.X;
            float minX = rotX ? 0.25f : 0.3125f;
            float minZ = rotX ? 0.3125f : 0.25f;
            float maxX = rotX ? 0.75f : 0.6875f;
            float f = maxZ = rotX ? 0.6875f : 0.75f;
            if (quad.m_111306_() == facing || quad.m_111306_() == facing.m_122424_()) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
                    if (quad.m_111306_() == facing) {
                        BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.1875f);
                        quadMap.get(null).add(topBotQuad);
                    } else {
                        quadMap.get(quad.m_111306_()).add(topBotQuad);
                    }
                }
            } else {
                boolean smallSide = rotX == (quad.m_111306_().m_122434_() == Direction.Axis.X);
                float minXZ = smallSide ? 0.3125f : 0.25f;
                float maxXZ = smallSide ? 0.6875f : 0.75f;
                float minY = facing == Direction.DOWN ? 0.8125f : 0.0f;
                float maxY = facing == Direction.DOWN ? 1.0f : 0.1875f;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, minY, maxXZ, maxY)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, smallSide ? 0.75f : 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        } else if (quad.m_111306_() == facing || quad.m_111306_() == facing.m_122424_()) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(faceQuad, 0.3125f, 0.25f, 0.6875f, 0.75f)) {
                if (quad.m_111306_() == facing) {
                    BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, 0.1875f);
                    quadMap.get(null).add(faceQuad);
                } else {
                    quadMap.get(quad.m_111306_()).add(faceQuad);
                }
            }
        } else {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            boolean negative;
            boolean xAxis = facing.m_122434_() == Direction.Axis.X;
            boolean bl = negative = facing.m_122421_() == Direction.AxisDirection.NEGATIVE;
            float f = xAxis ? (negative ? 0.8125f : 0.0f) : (minX = 0.3125f);
            float f2 = xAxis ? (negative ? 1.0f : 0.1875f) : (maxX = 0.6875f);
            float f3 = xAxis ? 0.3125f : (minZ = negative ? 0.8125f : 0.0f);
            float f4 = xAxis ? 0.6875f : (maxZ = negative ? 1.0f : 0.1875f);
            if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.75f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else {
                float minXZ = xAxis ? minX : minZ;
                float maxXZ = xAxis ? maxX : maxZ;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.25f, maxXZ, 0.75f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }
    }
}

