/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public class FramedTrapDoorModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean open;

    public FramedTrapDoorModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.top = state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        this.open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad sideQuad;
        if (this.open) {
            if (quad.m_111306_() == this.dir) {
                BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.setQuadPosInFacingDir(frontQuad, 0.1875f);
                quadMap.get(null).add(frontQuad);
            } else if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.1875f)) {
                    quadMap.get(quad.m_111306_()).add(topBotQuad);
                }
            } else {
                boolean facePositive;
                BakedQuad sideQuad2 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2, !(facePositive = this.dir.m_122421_() == Direction.AxisDirection.POSITIVE), 0.1875f)) {
                    quadMap.get(quad.m_111306_()).add(sideQuad2);
                }
            }
        } else if (this.top && quad.m_111306_() == Direction.DOWN || !this.top && quad.m_111306_() == Direction.UP) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.1875f);
            quadMap.get(null).add(topBotQuad);
        } else if (quad.m_111306_().m_122434_() != Direction.Axis.Y && BakedQuadTransformer.createHorizontalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), this.top, 0.1875f)) {
            quadMap.get(quad.m_111306_()).add(sideQuad);
        }
    }
}

