/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public class FramedWallTorchModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_torch");
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.0f, 0.21875f, 0.5f);
    private final Direction dir;

    public FramedWallTorchModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)Blocks.f_50081_.m_49966_(), (RenderType)layer);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData extraData, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, extraData);
        for (BakedQuad quad : quads) {
            if (quad.m_173410_().m_118413_().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.4375f, 0.4375f, 0.5625f, 0.5625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.71875f : 0.78125f);
                BakedQuadTransformer.offsetQuadInDir(topBotQuad, Direction.WEST, 0.5f);
                quadMap.get(null).add(topBotQuad);
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.4375f, 0.0f, 0.5625f, 0.5f)) {
                if (quad.m_111306_() == Direction.EAST) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.0625f);
                } else if (quad.m_111306_() == Direction.WEST) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 1.0625f);
                } else {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    BakedQuadTransformer.offsetQuadInDir(sideQuad, Direction.WEST, 0.5f);
                }
                BakedQuadTransformer.offsetQuadInDir(sideQuad, Direction.UP, 0.21875f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }

    @Override
    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
        float yAngle = 270.0f - this.dir.m_122435_();
        quadMap.get(null).forEach(q -> {
            BakedQuadTransformer.rotateQuadAroundAxis(q, Direction.Axis.Z, ROTATION_ORIGIN, -22.5f, false);
            BakedQuadTransformer.rotateQuadAroundAxisCentered(q, Direction.Axis.Y, yAngle, false);
        });
    }

    @Override
    public boolean m_7541_() {
        return false;
    }
}

