/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.client.util.GhostVertexConsumer;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class GhostBlockRenderer {
    private static final FramedBlockData GHOST_MODEL_DATA = new FramedBlockData(true);
    private static final FramedBlockData GHOST_MODEL_DATA_LEFT = new FramedBlockData(true);
    private static final FramedBlockData GHOST_MODEL_DATA_RIGHT = new FramedBlockData(true);
    private static final String PROFILER_KEY = "framedblocks_ghost_block";
    private static final Method BLOCKITEM_GETPLACESTATE = ObfuscationReflectionHelper.findMethod(BlockItem.class, (String)"m_5965_", (Class[])new Class[]{BlockPlaceContext.class});

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        GHOST_MODEL_DATA.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA.setData(FramedDoubleBlockEntity.DATA_LEFT, GHOST_MODEL_DATA_LEFT);
        GHOST_MODEL_DATA.setData(FramedDoubleBlockEntity.DATA_RIGHT, GHOST_MODEL_DATA_RIGHT);
    }

    public static void drawGhostBlock(MultiBufferSource buffers, PoseStack mstack) {
        BlockPos renderPos;
        boolean doRender;
        BlockState renderState;
        Block block;
        if (!ClientConfig.showGhostBlocks) {
            return;
        }
        HitResult mouseOver = GhostBlockRenderer.mc().f_91077_;
        if (mouseOver == null || mouseOver.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult target = (BlockHitResult)mouseOver;
        boolean blueprint = false;
        boolean rail = false;
        ItemStack stack = GhostBlockRenderer.mc().f_91074_.m_21205_();
        if (stack.m_41720_() instanceof FramedBlueprintItem) {
            block = FramedBlueprintItem.getTargetBlock(stack);
            blueprint = true;
        } else {
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                block = item2.m_40614_();
                rail = item2 == Items.f_41964_;
            } else {
                return;
            }
        }
        if (!(block instanceof IFramedBlock) && !rail) {
            return;
        }
        if (!blueprint && (renderState = GhostBlockRenderer.tryBuildDoublePanel(target, block)) != null) {
            doRender = true;
            renderPos = target.m_82425_();
        } else if (!blueprint && (renderState = GhostBlockRenderer.tryBuildDoubleSlab(target, block)) != null) {
            doRender = true;
            renderPos = target.m_82425_();
        } else if (rail) {
            BlockState state = GhostBlockRenderer.mc().f_91073_.m_8055_(target.m_82425_());
            if (state.m_60734_() == FBContent.blockFramedSlope.get()) {
                renderPos = target.m_82425_();
                RailShape shape = FramedRailSlopeBlock.shapeFromDirection((Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR));
                renderState = (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)shape);
                BlockState railSlope = (BlockState)((Block)FBContent.blockFramedRailSlope.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)shape);
                doRender = railSlope.m_60710_((LevelReader)GhostBlockRenderer.mc().f_91073_, renderPos);
            } else {
                doRender = false;
                renderPos = BlockPos.f_121853_;
                renderState = Blocks.f_50016_.m_49966_();
            }
        } else {
            BlockPlaceContext context = new BlockPlaceContext((Player)GhostBlockRenderer.mc().f_91074_, InteractionHand.MAIN_HAND, stack, target);
            renderPos = context.m_8083_();
            renderState = GhostBlockRenderer.getStateForPlacement(context, block);
            boolean bl = doRender = renderState != null && GhostBlockRenderer.mc().f_91073_.m_45752_(renderState, renderPos, CollisionContext.m_82750_((Entity)GhostBlockRenderer.mc().f_91074_)) && GhostBlockRenderer.mc().f_91073_.m_8055_(renderPos).m_60629_(context);
        }
        if (doRender) {
            CompoundTag beTag;
            BlockState camoState = Blocks.f_50016_.m_49966_();
            BlockState camoStateTwo = Blocks.f_50016_.m_49966_();
            if (blueprint) {
                beTag = stack.m_41698_("blueprint_data").m_128469_("camo_data");
                camoState = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state"));
                if (renderState.m_60734_() instanceof AbstractFramedDoubleBlock) {
                    camoStateTwo = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state_two"));
                    if (block == FBContent.blockFramedDoublePanel.get() && renderState.m_61143_((Property)PropertyHolder.FACING_NE) != GhostBlockRenderer.mc().f_91074_.m_6350_()) {
                        BlockState temp = camoState;
                        camoState = camoStateTwo;
                        camoStateTwo = temp;
                    }
                    GHOST_MODEL_DATA_LEFT.setCamoState(camoState);
                    GHOST_MODEL_DATA_RIGHT.setCamoState(camoStateTwo);
                } else {
                    GHOST_MODEL_DATA.setCamoState(camoState);
                }
            }
            GhostBlockRenderer.doRenderGhostBlock(mstack, buffers, renderPos, renderState, camoState, camoStateTwo);
            if (renderState.m_60734_() == FBContent.blockFramedDoor.get()) {
                if (blueprint) {
                    beTag = stack.m_41698_("blueprint_data").m_128469_("camo_data_two");
                    camoState = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state"));
                    GHOST_MODEL_DATA.setCamoState(camoState);
                }
                GhostBlockRenderer.doRenderGhostBlock(mstack, buffers, renderPos.m_7494_(), (BlockState)renderState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), camoState, camoStateTwo);
            }
            if (blueprint) {
                GHOST_MODEL_DATA.setCamoState(Blocks.f_50016_.m_49966_());
                GHOST_MODEL_DATA_LEFT.setCamoState(Blocks.f_50016_.m_49966_());
                GHOST_MODEL_DATA_RIGHT.setCamoState(Blocks.f_50016_.m_49966_());
            }
        }
    }

    private static void doRenderGhostBlock(PoseStack mstack, MultiBufferSource buffers, BlockPos renderPos, BlockState renderState, BlockState camoState, BlockState camoStateTwo) {
        GHOST_MODEL_DATA.setLevel((Level)GhostBlockRenderer.mc().f_91073_);
        GHOST_MODEL_DATA.setPos(renderPos);
        GHOST_MODEL_DATA_LEFT.setLevel((Level)GhostBlockRenderer.mc().f_91073_);
        GHOST_MODEL_DATA_LEFT.setPos(renderPos);
        GHOST_MODEL_DATA_RIGHT.setLevel((Level)GhostBlockRenderer.mc().f_91073_);
        GHOST_MODEL_DATA_RIGHT.setPos(renderPos);
        Vec3 offset = Vec3.m_82528_((Vec3i)renderPos).m_82546_(GhostBlockRenderer.mc().f_91063_.m_109153_().m_90583_());
        GhostVertexConsumer builder = new GhostVertexConsumer(buffers.m_6299_(RenderType.m_110466_()), 170);
        if (camoState.m_60795_() && camoStateTwo.m_60795_()) {
            GhostBlockRenderer.doRenderGhostBlockInLayer(mstack, builder, renderPos, renderState, RenderType.m_110463_(), offset);
        } else {
            for (RenderType type : RenderType.m_110506_()) {
                if (!GhostBlockRenderer.canRenderInLayer(camoState, type) && !GhostBlockRenderer.canRenderInLayer(camoStateTwo, type)) continue;
                GhostBlockRenderer.doRenderGhostBlockInLayer(mstack, builder, renderPos, renderState, type, offset);
            }
        }
        ((MultiBufferSource.BufferSource)buffers).m_109912_(RenderType.m_110466_());
        ForgeHooksClient.setRenderType(null);
    }

    private static boolean canRenderInLayer(BlockState camoState, RenderType layer) {
        if (camoState.m_60795_()) {
            return layer == RenderType.m_110463_();
        }
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)camoState, (RenderType)layer);
    }

    private static void doRenderGhostBlockInLayer(PoseStack mstack, VertexConsumer builder, BlockPos renderPos, BlockState renderState, RenderType layer, Vec3 offset) {
        ForgeHooksClient.setRenderType((RenderType)layer);
        mstack.m_85836_();
        mstack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        GhostBlockRenderer.mc().m_91289_().renderBatched(renderState, renderPos, (BlockAndTintGetter)GhostBlockRenderer.mc().f_91073_, mstack, builder, false, GhostBlockRenderer.mc().f_91073_.m_5822_(), (IModelData)GHOST_MODEL_DATA);
        mstack.m_85849_();
    }

    private static BlockState tryBuildDoubleSlab(BlockHitResult trace, Block heldBlock) {
        boolean top;
        if (heldBlock != FBContent.blockFramedSlab.get()) {
            return null;
        }
        BlockState target = GhostBlockRenderer.mc().f_91073_.m_8055_(trace.m_82425_());
        if (target.m_60734_() == heldBlock && ((top = ((Boolean)target.m_61143_((Property)PropertyHolder.TOP)).booleanValue()) && trace.m_82434_() == Direction.DOWN || !top && trace.m_82434_() == Direction.UP)) {
            return (BlockState)target.m_61124_((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(!top));
        }
        return null;
    }

    private static BlockState tryBuildDoublePanel(BlockHitResult trace, Block heldBlock) {
        Direction dir;
        if (heldBlock != FBContent.blockFramedPanel.get()) {
            return null;
        }
        BlockState target = GhostBlockRenderer.mc().f_91073_.m_8055_(trace.m_82425_());
        if (target.m_60734_() == heldBlock && (dir = (Direction)target.m_61143_((Property)PropertyHolder.FACING_HOR)).m_122424_() == trace.m_82434_()) {
            return (BlockState)target.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)dir.m_122424_());
        }
        return null;
    }

    private static BlockState getStateForPlacement(BlockPlaceContext ctx, Block block) {
        Item item = ctx.m_43722_().m_41720_();
        if (item instanceof StandingAndWallBlockItem) {
            try {
                return (BlockState)BLOCKITEM_GETPLACESTATE.invoke((Object)item, ctx);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                FramedBlocks.LOGGER.error("Encountered an error while getting placement state of ", (Throwable)e);
            }
        }
        return block.m_5573_(ctx);
    }

    private static Minecraft mc() {
        return Minecraft.m_91087_();
    }
}

