/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.AbstractFramedBlock;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedBlock
extends AbstractFramedBlock {
    public FramedBlock(BlockType blockType) {
        this(blockType, IFramedBlock.createProperties());
    }

    protected FramedBlock(BlockType blockType, BlockBehaviour.Properties props) {
        super(blockType, props);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        if (this.getBlockType() != BlockType.FRAMED_CUBE) {
            return false;
        }
        return super.m_7357_(state, level, pos, type);
    }

    protected static BlockState withSlopeType(BlockState state, Direction side, Direction facing, Vec3 hitVec) {
        state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        Vec3 hitPoint = Utils.fraction(hitVec);
        if (side.m_122434_() != Direction.Axis.Y) {
            if (hitPoint.m_7098_() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM));
        } else {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
            boolean xAxis = side.m_122434_() == Direction.Axis.X;
            boolean positive = side.m_122428_().m_122421_() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            state = xz > 0.5 == positive ? (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)side.m_122424_().m_122427_()) : (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)side.m_122424_());
        }
        return state;
    }

    protected static BlockState withCornerType(BlockState state, BlockPlaceContext context, Direction side, Vec3 hitPoint, Direction facing) {
        state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.BOTTOM));
        } else {
            boolean xAxis = context.m_43719_().m_122434_() == Direction.Axis.X;
            boolean positive = context.m_43719_().m_122428_().m_122421_() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            double y = hitPoint.m_7098_();
            CornerType type = xz > 0.5 == positive ? (y > 0.5 ? CornerType.HORIZONTAL_TOP_RIGHT : CornerType.HORIZONTAL_BOTTOM_RIGHT) : (y > 0.5 ? CornerType.HORIZONTAL_TOP_LEFT : CornerType.HORIZONTAL_BOTTOM_LEFT);
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type));
        }
        return state;
    }
}

