/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCollapsibleBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        CollapseFace face = (CollapseFace)((Object)((Object)state.m_61143_(PropertyHolder.COLLAPSED_FACE)));
        if (face == CollapseFace.NONE) {
            return true;
        }
        return dir == face.toDirection().m_122424_();
    };
    private static final LoadingCache<Integer, VoxelShape> SHAPE_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new ShapeLoader());

    public FramedCollapsibleBlock(BlockType blockType) {
        super(blockType, IFramedBlock.createProperties().m_60988_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.COLLAPSED_FACE});
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_41720_() != FBContent.itemFramedHammer.get()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            if (!level.m_5776_()) {
                be.handleDeform(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockEntity blockEntity;
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.m_83040_();
        }
        CollapseFace face = (CollapseFace)((Object)state.m_61143_(PropertyHolder.COLLAPSED_FACE));
        if (face != CollapseFace.NONE && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            int offsets = be.getPackedOffsets();
            return (VoxelShape)SHAPE_CACHE.getUnchecked((Object)(offsets |= face.toDirection().m_122411_() << 20));
        }
        return Shapes.m_83144_();
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedCollapsibleBlockEntity(pos, state);
    }

    private static class ShapeLoader
    extends CacheLoader<Integer, VoxelShape> {
        private ShapeLoader() {
        }

        public VoxelShape load(Integer packedData) {
            Direction face = Direction.m_122376_((int)(packedData >> 20));
            byte[] offsets = FramedCollapsibleBlockEntity.unpackOffsets(packedData & 0xFFFFF);
            boolean positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
            boolean flipX = face == Direction.NORTH || face == Direction.EAST;
            boolean flipZ = face != Direction.UP;
            VoxelShape result = Shapes.m_83040_();
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    double x0 = flipX ? 1.0 - (double)x / 4.0 : (double)x / 4.0;
                    double x1 = flipX ? 1.0 - (double)(x + 1) / 4.0 : (double)(x + 1) / 4.0;
                    double z0 = flipZ ? 1.0 - (double)z / 4.0 : (double)z / 4.0;
                    double z1 = flipZ ? 1.0 - (double)(z + 1) / 4.0 : (double)(z + 1) / 4.0;
                    double y0 = Mth.m_14012_((double)x0, (double)z0, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                    double y1 = Mth.m_14012_((double)x1, (double)z1, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                    double y = positive ? Math.max(16.0 - Math.min(y0, y1), (double)2.0E-5f) : Math.min(Math.min(y0, y1), 15.999980000000505);
                    VoxelShape shape = switch (face) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.NORTH -> Block.m_49796_((double)(x * 4), (double)(z * 4), (double)y, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)16.0);
                        case Direction.EAST -> Block.m_49796_((double)0.0, (double)(z * 4), (double)(x * 4), (double)y, (double)((z + 1) * 4), (double)((x + 1) * 4));
                        case Direction.SOUTH -> Block.m_49796_((double)(x * 4), (double)(z * 4), (double)0.0, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)y);
                        case Direction.WEST -> Block.m_49796_((double)y, (double)(z * 4), (double)(x * 4), (double)16.0, (double)((z + 1) * 4), (double)((x + 1) * 4));
                        case Direction.UP -> Block.m_49796_((double)(x * 4), (double)0.0, (double)(z * 4), (double)((x + 1) * 4), (double)y, (double)((z + 1) * 4));
                        case Direction.DOWN -> Block.m_49796_((double)(x * 4), (double)y, (double)(z * 4), (double)((x + 1) * 4), (double)16.0, (double)((z + 1) * 4));
                    };
                    result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
                }
            }
            result = result.m_83296_();
            return result;
        }
    }
}

