/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class HalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction baseFace;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
        Direction stairFace = right ? dir.m_122427_() : dir.m_122428_();
        Direction direction = baseFace = top ? Direction.UP : Direction.DOWN;
        if (adjState.m_60713_((Block)FBContent.blockFramedHalfStairs.get())) {
            return HalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, right, stairFace, adjState, side);
        }
        if (side == stairFace) {
            if (adjState.m_60713_((Block)FBContent.blockFramedStairs.get())) {
                return HalfStairsSkipPredicate.testAgainstStairs(level, pos, top, adjState, side);
            }
            if (adjState.m_60713_((Block)FBContent.blockFramedVerticalStairs.get())) {
                return HalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, right, adjState, side);
            }
        } else {
            if (adjState.m_60713_((Block)FBContent.blockFramedSlabEdge.get())) {
                return HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, right, baseFace, adjState, side);
            }
            if (adjState.m_60713_((Block)FBContent.blockFramedCornerPillar.get())) {
                return HalfStairsSkipPredicate.testAgainstCornerPillar(level, pos, dir, right, baseFace, adjState, side);
            }
            if (adjState.m_60713_((Block)FBContent.blockFramedSlabCorner.get())) {
                return HalfStairsSkipPredicate.testAgainstSlabCorner(level, pos, dir, top, right, baseFace, adjState, side);
            }
            if (adjState.m_60713_((Block)FBContent.blockFramedPanel.get())) {
                return HalfStairsSkipPredicate.testAgainstPanel(level, pos, dir, right, baseFace, adjState, side);
            }
            if (adjState.m_60713_((Block)FBContent.blockFramedDoublePanel.get())) {
                return HalfStairsSkipPredicate.testAgainstDoublePanel(level, pos, dir, stairFace, baseFace, adjState, side);
            }
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, Direction stairFace, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (side == stairFace) {
            return adjDir == dir && adjTop == top && adjRight != right && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side.m_122434_() == Direction.Axis.Y) {
            return adjDir == dir && adjTop != top && adjRight == right && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir) {
            return adjDir == dir.m_122424_() && adjRight != right && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        boolean adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        return top == adjTop && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (right && adjDir == dir || !right && adjDir == dir.m_122427_()) {
            return adjType.isTop() != top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (right && adjDir == dir.m_122427_() || !right && adjDir == dir.m_122428_()) {
            return adjTop == top == (side == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.m_122424_() && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir && (right && adjDir == dir.m_122424_() || !right && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == baseFace.m_122424_() && (right && adjDir == dir.m_122427_() || !right && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.m_122424_() && side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (right && adjDir == dir.m_122427_() || !right && adjDir == dir) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (right && adjDir == dir.m_122427_() || !right && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, Direction stairFace, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        return adjDir.m_122434_() != dir.m_122434_() && SideSkipPredicate.compareState(level, pos, side, stairFace);
    }
}

