/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class ThreewayCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Block block = adjState.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return false;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        IBlockType adjBlock = block2.getBlockType();
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return ThreewayCornerSkipPredicate.testAgainstThreewayCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return ThreewayCornerSkipPredicate.testAgainstInnerThreewayCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return ThreewayCornerSkipPredicate.testAgainstDoubleThreewayCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE || adjBlock == BlockType.FRAMED_RAIL_SLOPE) {
            return ThreewayCornerSkipPredicate.testAgainstSlope(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return ThreewayCornerSkipPredicate.testAgainstDoubleSlope(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return ThreewayCornerSkipPredicate.testAgainstCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return ThreewayCornerSkipPredicate.testAgainstInnerCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return ThreewayCornerSkipPredicate.testAgainstDoubleCorner(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side.m_122434_() == Direction.Axis.Y && adjTop != top && adjDir == dir && side == Direction.UP == top) {
            return SideSkipPredicate.compareState(level, pos, side, side);
        }
        if (adjTop == top && (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, side);
        }
        return false;
    }

    private static boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (adjTop == top && adjDir == dir && (side == dir || side == dir.m_122428_() || side == Direction.DOWN && !top || side == Direction.UP && top)) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (adjTop == top && adjDir == dir && (side == dir || side == dir.m_122428_() || side == Direction.UP && top || side == Direction.DOWN && !top)) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        if (adjTop == top && adjDir == dir.m_122424_() && (side == Direction.UP && top || side == Direction.DOWN || !top)) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        if (adjTop != top && (side == dir.m_122428_() && adjDir == dir.m_122428_() || side == dir && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlope(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = FramedUtils.getBlockFacing(adjState);
        SlopeType adjType = FramedUtils.getSlopeType(adjState);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir) {
            return adjType != SlopeType.HORIZONTAL && adjType == SlopeType.TOP == top && SideSkipPredicate.compareState(level, pos, side, side);
        }
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return adjType == SlopeType.HORIZONTAL && adjDir == dir && SideSkipPredicate.compareState(level, pos, side, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (adjType != SlopeType.HORIZONTAL) {
            if (side == dir.m_122428_() && adjDir == dir || side == dir && adjDir == dir.m_122428_()) {
                return adjType == SlopeType.TOP == top && SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
            if (side == dir.m_122428_() && adjDir == dir.m_122424_() || side == dir && adjDir == dir.m_122427_()) {
                return adjType == SlopeType.TOP != top && SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
        } else if ((!top && side == Direction.DOWN || top && side == Direction.UP) && (adjDir == dir || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if ((side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) && !adjType.isHorizontal()) {
            return adjType.isTop() == top && SideSkipPredicate.compareState(level, pos, side, side);
        }
        if (side == dir && adjDir == dir.m_122428_() && !adjType.isRight() || side == dir.m_122428_() && adjDir == dir && adjType.isRight()) {
            return adjType.isTop() == top && adjType.isHorizontal() && SideSkipPredicate.compareState(level, pos, side, side);
        }
        if ((!top && side == Direction.DOWN || top && side == Direction.UP) && (adjDir == dir.m_122428_() && adjType.isRight() || adjDir == dir && !adjType.isRight())) {
            return adjType.isTop() != top && adjType.isHorizontal() && SideSkipPredicate.compareState(level, pos, side, side);
        }
        return false;
    }

    private static boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!(adjType.isHorizontal() || adjDir != dir || side != dir && side != dir.m_122428_() || adjType.isTop() != top)) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        if (adjType.isHorizontal() && (side == dir && adjType.isRight() || side == dir.m_122428_() && !adjType.isRight()) && adjType.isTop() == top) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        if (adjType.isHorizontal() && (side == Direction.DOWN && !top || side == Direction.UP && top) && adjType.isTop() == top) {
            return (!adjType.isRight() && adjDir == dir || adjType.isRight() && adjDir == dir.m_122428_()) && SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal()) {
            if (adjDir == dir && adjType.isTop() == top && (side == dir || side == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
            }
            if (adjType.isTop() != top && (side == dir && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
            }
        } else if (adjType.isTop() == top) {
            if (!adjType.isRight() && adjDir == dir || adjType.isRight() && adjDir == dir.m_122428_()) {
                if (side == Direction.DOWN && !top || side == Direction.UP && top) {
                    return SideSkipPredicate.compareState(level, pos, side, adjDir);
                }
                if (side == dir && adjType.isRight() || side == dir.m_122428_() && !adjType.isRight()) {
                    return SideSkipPredicate.compareState(level, pos, side, adjDir);
                }
            } else if (side.m_122434_() == Direction.Axis.Y && (!adjType.isRight() && adjDir == dir.m_122424_() || adjType.isRight() && adjDir == dir.m_122427_()) && (side == Direction.DOWN && !top || side == Direction.UP && top)) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
        } else if (side == dir && adjDir == dir.m_122427_() && !adjType.isRight() || side == dir.m_122428_() && adjDir == dir.m_122424_() && adjType.isRight()) {
            return SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
        }
        return false;
    }
}

