/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class VerticalStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return VerticalStairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return VerticalStairsSkipPredicate.testAgainstStairs(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return VerticalStairsSkipPredicate.testAgainstPanel(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return VerticalStairsSkipPredicate.testAgainstDoublePanel(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabCorner.get()) {
            return VerticalStairsSkipPredicate.testAgainstCorner(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedCornerPillar.get()) {
            return VerticalStairsSkipPredicate.testAgainstPillar(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get() && type != StairsType.VERTICAL && side.m_122434_() != Direction.Axis.Y) {
            return VerticalStairsSkipPredicate.testAgainstEdge(level, pos, dir, type, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedHalfStairs.get())) {
            return VerticalStairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, type, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (!type.isBottom() && !adjType.isTop() && side == Direction.DOWN || !type.isTop() && !adjType.isBottom() && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        boolean adjBottom;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean bl = adjBottom = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM;
        if (type == StairsType.VERTICAL && (side == Direction.UP && !adjBottom || side == Direction.DOWN && adjBottom)) {
            StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
            if (adjDir == dir && adjShape == StairsShape.INNER_LEFT || adjDir == dir.m_122428_() && adjShape == StairsShape.INNER_RIGHT) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (type.isTop() == adjBottom && (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        if (side == dir.m_122427_() && (adjDir == dir || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        if (side == dir.m_122424_() && (adjDir == dir.m_122428_() || adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir.m_122428_());
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type == StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if ((side.m_122434_() == Direction.Axis.Y || side == dir.m_122424_() || side == dir.m_122427_()) && type.isTop() != adjTop && dir == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (type == StairsType.VERTICAL ? (side == dir.m_122427_() || side == dir.m_122424_()) && adjDir == dir : side.m_122434_() == Direction.Axis.Y && side == Direction.UP == type.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_()) {
            return adjTop != type.isTop() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (adjTop == type.isTop()) {
            return false;
        }
        if (adjRight && adjDir == dir && side == dir.m_122428_() || !adjRight && adjDir == dir.m_122428_() && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

