/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.item;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.FramedToolType;
import xfacthd.framedblocks.common.item.FramedToolItem;

public class FramedBlueprintItem
extends FramedToolItem {
    public static final String CONTAINED_BLOCK = "desc.framed_blocks:blueprint_block";
    public static final String CAMO_BLOCK = "desc.framed_blocks:blueprint_camo";
    public static final String IS_ILLUMINATED = "desc.framed_blocks:blueprint_illuminated";
    public static final MutableComponent BLOCK_NONE = new TranslatableComponent("desc.framed_blocks:blueprint_none").m_130940_(ChatFormatting.RED);
    public static final MutableComponent BLOCK_INVALID = new TranslatableComponent("desc.framed_blocks:blueprint_invalid").m_130940_(ChatFormatting.RED);
    public static final MutableComponent ILLUMINATED_FALSE = new TranslatableComponent("desc.framed_blocks:blueprint_illuminated_false").m_130940_(ChatFormatting.RED);
    public static final MutableComponent ILLUMINATED_TRUE = new TranslatableComponent("desc.framed_blocks:blueprint_illuminated_true").m_130940_(ChatFormatting.GREEN);
    public static final MutableComponent CANT_COPY = new TranslatableComponent("desc.framed_blocks:blueprint_cant_copy").m_130940_(ChatFormatting.RED);

    public FramedBlueprintItem(FramedToolType type) {
        super(type);
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                CompoundTag tag = stack.m_41698_("blueprint_data");
                tag.m_128473_("framed_block");
                tag.m_128473_("camo_data");
                tag.m_128473_("camo_data_two");
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        CompoundTag tag = context.m_43722_().m_41698_("blueprint_data");
        if (player.m_6144_()) {
            return FramedBlueprintItem.writeBlueprint(level, pos, tag);
        }
        if (!tag.m_128456_()) {
            return this.readBlueprint(context, player, tag);
        }
        return super.m_6225_(context);
    }

    private static InteractionResult writeBlueprint(Level level, BlockPos pos, CompoundTag tag) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FramedBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FramedBlockEntity be = (FramedBlockEntity)blockEntity;
        if (!level.m_5776_()) {
            BlockState state = level.m_8055_(pos);
            String block = state.m_60734_().getRegistryName().toString();
            tag.m_128359_("framed_block", block);
            CompoundTag nbt = be.writeToBlueprint();
            if (state.m_60734_() == FBContent.blockFramedDoor.get()) {
                CompoundTag compoundTag;
                boolean top = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER;
                BlockPos posTwo = top ? pos.m_7495_() : pos.m_7494_();
                BlockEntity blockEntity2 = level.m_7702_(posTwo);
                if (blockEntity2 instanceof FramedBlockEntity) {
                    FramedBlockEntity beTwo = (FramedBlockEntity)blockEntity2;
                    compoundTag = beTwo.writeToBlueprint();
                } else {
                    compoundTag = new CompoundTag();
                }
                CompoundTag nbtTwo = compoundTag;
                tag.m_128365_("camo_data", (net.minecraft.nbt.Tag)(top ? nbtTwo : nbt));
                tag.m_128365_("camo_data_two", (net.minecraft.nbt.Tag)(top ? nbt : nbtTwo));
            } else {
                tag.m_128365_("camo_data", (net.minecraft.nbt.Tag)nbt);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private InteractionResult readBlueprint(UseOnContext context, Player player, CompoundTag tag) {
        Block block = FramedBlueprintItem.getTargetBlock(context.m_43722_());
        if (block.m_49966_().m_60795_()) {
            return InteractionResult.FAIL;
        }
        Item item = block.m_5456_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.FAIL;
        }
        if (FramedBlueprintItem.checkMissingMaterials(player, item, tag)) {
            return InteractionResult.FAIL;
        }
        return this.tryPlace(context, player, item, tag);
    }

    private static boolean checkMissingMaterials(Player player, Item item, CompoundTag tag) {
        int count;
        if (player.m_150110_().f_35937_) {
            return false;
        }
        CompoundTag camoData = tag.m_128469_("camo_data");
        ItemStack camo = ItemStack.m_41712_((CompoundTag)camoData.m_128469_("camo_stack"));
        ItemStack camoTwo = camoData.m_128441_("camo_stack_two") ? ItemStack.m_41712_((CompoundTag)camoData.m_128469_("camo_stack_two")) : ItemStack.f_41583_;
        boolean glowstone = tag.m_128469_("camo_data").m_128471_("glowing");
        boolean doubleBlock = false;
        if (item == ((Block)FBContent.blockFramedDoor.get()).m_5456_() && tag.m_128441_("camo_data_two")) {
            camoTwo = ItemStack.m_41712_((CompoundTag)tag.m_128469_("camo_data_two").m_128469_("camo_stack"));
        } else if (item == ((Block)FBContent.blockFramedDoublePanel.get()).m_5456_()) {
            item = ((Block)FBContent.blockFramedPanel.get()).m_5456_();
            doubleBlock = true;
        } else if (item == ((Block)FBContent.blockFramedDoubleSlab.get()).m_5456_()) {
            item = ((Block)FBContent.blockFramedSlab.get()).m_5456_();
            doubleBlock = true;
        }
        if (doubleBlock ? (count = player.m_150109_().m_18947_(item)) < 2 : !player.m_150109_().m_36063_(new ItemStack((ItemLike)item))) {
            return true;
        }
        if (!camo.m_41619_() && camo.m_150930_(camoTwo.m_41720_())) {
            count = player.m_150109_().m_18947_(camo.m_41720_());
            if (count < 2) {
                return true;
            }
        } else {
            if (!camo.m_41619_() && !player.m_150109_().m_36063_(camo)) {
                return true;
            }
            if (!camoTwo.m_41619_() && !player.m_150109_().m_36063_(camoTwo)) {
                return true;
            }
        }
        return glowstone && !player.m_150109_().m_36001_((Tag)Tags.Items.DUSTS_GLOWSTONE);
    }

    private InteractionResult tryPlace(UseOnContext context, Player player, Item item, CompoundTag tag) {
        ItemStack dummyStack = new ItemStack((ItemLike)item, 1);
        dummyStack.m_41784_().m_128365_("BlockEntityTag", (net.minecraft.nbt.Tag)tag.m_128469_("camo_data").m_6426_());
        UseOnContext placeContext = new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), dummyStack, new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
        BlockPos topPos = new BlockPlaceContext(placeContext).m_8083_().m_7494_();
        InteractionResult result = item.m_6225_(placeContext);
        if (!context.m_43725_().m_5776_() && result.m_19077_()) {
            if (item == ((Block)FBContent.blockFramedDoor.get()).m_5456_() && context.m_43725_().m_7702_(topPos) instanceof FramedBlockEntity && tag.m_128425_("camo_data_two", 10)) {
                dummyStack.m_41784_().m_128365_("BlockEntityTag", tag.m_128423_("camo_data_two"));
                BlockItem.m_40582_((Level)context.m_43725_(), (Player)context.m_43723_(), (BlockPos)topPos, (ItemStack)dummyStack);
            }
            if (!player.m_150110_().f_35937_) {
                FramedBlueprintItem.consumeItems(player, item, tag);
            }
        }
        return result;
    }

    private static void consumeItems(Player player, Item item, CompoundTag tag) {
        CompoundTag camoData = tag.m_128469_("camo_data");
        ItemStack camo = ItemStack.m_41712_((CompoundTag)camoData.m_128469_("camo_stack"));
        ItemStack camoTwo = camoData.m_128441_("camo_stack_two") ? ItemStack.m_41712_((CompoundTag)camoData.m_128469_("camo_stack_two")) : ItemStack.f_41583_;
        boolean glowstone = camoData.m_128471_("glowing");
        boolean doubleBlock = false;
        if (item == ((Block)FBContent.blockFramedDoor.get()).m_5456_() && tag.m_128441_("camo_data_two")) {
            camoTwo = ItemStack.m_41712_((CompoundTag)tag.m_128469_("camo_data_two").m_128469_("camo_stack"));
        } else if (item == ((Block)FBContent.blockFramedDoublePanel.get()).m_5456_()) {
            item = ((Block)FBContent.blockFramedPanel.get()).m_5456_();
            doubleBlock = true;
        } else if (item == ((Block)FBContent.blockFramedDoubleSlab.get()).m_5456_()) {
            item = ((Block)FBContent.blockFramedSlab.get()).m_5456_();
            doubleBlock = true;
        }
        int foundBlock = doubleBlock ? 2 : 1;
        boolean foundCamo = false;
        boolean foundCamoTwo = false;
        boolean foundGlowstone = false;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (foundBlock > 0 && stack.m_150930_(item)) {
                int size = stack.m_41613_();
                stack.m_41774_(foundBlock);
                foundBlock -= size - stack.m_41613_();
                inv.m_6596_();
            }
            if (!foundCamo && !camo.m_41619_() && stack.m_150930_(camo.m_41720_())) {
                foundCamo = true;
                stack.m_41774_(1);
                inv.m_6596_();
            }
            if (!foundCamoTwo && !camoTwo.m_41619_() && stack.m_150930_(camoTwo.m_41720_())) {
                foundCamoTwo = true;
                stack.m_41774_(1);
                inv.m_6596_();
            }
            if (!foundGlowstone && glowstone && stack.m_150922_((Tag)Tags.Items.DUSTS_GLOWSTONE)) {
                foundGlowstone = true;
                stack.m_41774_(1);
                inv.m_6596_();
            }
            if (!(foundBlock > 0 || !camo.m_41619_() && !foundCamo || !camoTwo.m_41619_() && !foundCamoTwo || glowstone && !foundGlowstone)) break;
        }
    }

    public static Block getTargetBlock(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("blueprint_data");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("framed_block")));
        Objects.requireNonNull(block);
        return block;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        CompoundTag tag = stack.m_41698_("blueprint_data");
        if (tag.m_128456_()) {
            components.add((Component)new TranslatableComponent(CONTAINED_BLOCK, new Object[]{BLOCK_NONE}).m_130940_(ChatFormatting.GOLD));
        } else {
            MutableComponent mutableComponent;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("framed_block")));
            MutableComponent blockName = block == null ? BLOCK_INVALID : block.m_49954_().m_130940_(ChatFormatting.WHITE);
            CompoundTag beTag = tag.m_128469_("camo_data");
            if (!(block instanceof IFramedBlock)) {
                mutableComponent = BLOCK_NONE;
            } else {
                IFramedBlock fb = (IFramedBlock)block;
                mutableComponent = (Component)fb.printCamoBlock(beTag).orElse(BLOCK_NONE);
            }
            MutableComponent camoName = mutableComponent;
            MutableComponent illuminated = beTag.m_128471_("glowing") ? ILLUMINATED_TRUE : ILLUMINATED_FALSE;
            MutableComponent lineOne = new TranslatableComponent(CONTAINED_BLOCK, new Object[]{blockName}).m_130940_(ChatFormatting.GOLD);
            MutableComponent lineTwo = new TranslatableComponent(CAMO_BLOCK, new Object[]{camoName}).m_130940_(ChatFormatting.GOLD);
            MutableComponent lineThree = new TranslatableComponent(IS_ILLUMINATED, new Object[]{illuminated}).m_130940_(ChatFormatting.GOLD);
            components.addAll(Arrays.asList(lineOne, lineTwo, lineThree));
        }
    }
}

