/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.blocks.VerticalSlabBlock;
import net.mehvahdjukaar.selene.util.WoodSetType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class BlockSetHandler {
    public static Map<ResourceLocation, WoodSetType> WOOD_TYPES = new LinkedHashMap<ResourceLocation, WoodSetType>();
    private static boolean hasFilledWoodTypes = false;
    private static final Map<String, Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>>> LATE_REGISTRATION_QUEUE = new HashMap<String, Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>>>();

    public static void registerCustomWoodType(WoodSetType woodSetType) {
        WOOD_TYPES.put(woodSetType.id, woodSetType);
    }

    public static WoodSetType getWoodTypeFromNBT(String name) {
        return WOOD_TYPES.getOrDefault(new ResourceLocation(name), WoodSetType.OAK_WOOD_TYPE);
    }

    protected static void registerModLateBlockAndItems(RegistryEvent.Register<Item> event) {
        String modId;
        Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>> registrationQueues;
        if (!hasFilledWoodTypes) {
            BlockSetHandler.findAllAvailableWoodTypes();
            hasFilledWoodTypes = true;
        }
        if ((registrationQueues = LATE_REGISTRATION_QUEUE.get(modId = ModLoadingContext.get().getActiveContainer().getModId())) != null) {
            List blockQueue = (List)registrationQueues.getFirst();
            blockQueue.forEach(Runnable::run);
            List itemQueue = (List)registrationQueues.getSecond();
            itemQueue.forEach(q -> q.accept(event));
        }
        LATE_REGISTRATION_QUEUE.remove(registrationQueues);
    }

    public static <T extends IForgeRegistryEntry<T>> void addWoodRegistrationCallback(WoodRegistryCallback<T> registrationFunction, Class<T> regType) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (regType == Block.class || regType == Item.class) {
            String modId = ModLoadingContext.get().getActiveContainer().getModId();
            Pair registrationQueues = LATE_REGISTRATION_QUEUE.computeIfAbsent(modId, s -> {
                bus.addGenericListener(Item.class, EventPriority.HIGHEST, BlockSetHandler::registerModLateBlockAndItems);
                return Pair.of(new ArrayList(), new ArrayList());
            });
            if (regType == Block.class) {
                Consumer<RegistryEvent.Register> eventConsumer = e -> {
                    Runnable lateRegistration = () -> {
                        IForgeRegistry registry = e.getRegistry();
                        if (registry instanceof ForgeRegistry) {
                            ForgeRegistry fr = (ForgeRegistry)registry;
                            boolean frozen = fr.isLocked();
                            fr.unfreeze();
                            registrationFunction.accept((RegistryEvent.Register)e, WOOD_TYPES.values());
                            if (frozen) {
                                fr.freeze();
                            }
                        }
                    };
                    ((List)registrationQueues.getFirst()).add(lateRegistration);
                };
                bus.addGenericListener(regType, EventPriority.HIGHEST, eventConsumer);
            } else {
                Consumer<RegistryEvent.Register> itemEvent = e -> registrationFunction.accept((RegistryEvent.Register)e, WOOD_TYPES.values());
                ((List)registrationQueues.getSecond()).add(itemEvent);
            }
        } else {
            Consumer<RegistryEvent.Register> eventConsumer = e -> registrationFunction.accept((RegistryEvent.Register)e, WOOD_TYPES.values());
            bus.addGenericListener(regType, eventConsumer);
        }
    }

    private static void findAllAvailableWoodTypes() {
        LinkedHashMap<ResourceLocation, WoodSetType> map = new LinkedHashMap<ResourceLocation, WoodSetType>();
        map.put(WoodSetType.OAK_WOOD_TYPE.id, WoodSetType.OAK_WOOD_TYPE);
        for (Block b : ForgeRegistries.BLOCKS) {
            BlockSetHandler.getWoodSetType(b).ifPresent(t -> {
                if (!map.containsKey(t.id)) {
                    map.put(t.id, (WoodSetType)t);
                }
            });
        }
        WOOD_TYPES = map;
    }

    private static Optional<WoodSetType> getWoodSetType(Block baseBlock) {
        BlockState state;
        Material mat;
        ResourceLocation baseRes = baseBlock.getRegistryName();
        String name = null;
        String path = baseRes.m_135815_();
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        if (name != null && ((mat = (state = baseBlock.m_49966_()).m_60767_()) == Material.f_76320_ || mat == Material.f_76321_)) {
            ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), name);
            return Optional.of(new WoodSetType(id, baseBlock));
        }
        return Optional.empty();
    }

    public static EnumMap<VariantType, RegistryObject<Block>> registerFullBlockSet(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, String baseName, Block parentBlock, boolean isHidden) {
        EnumMap<VariantType, RegistryObject<Block>> map = new EnumMap<VariantType, RegistryObject<Block>>(VariantType.class);
        for (VariantType type : VariantType.values()) {
            Object name = baseName;
            if (!type.equals((Object)VariantType.BLOCK)) {
                name = (String)name + "_" + type.name().toLowerCase(Locale.ROOT);
            }
            RegistryObject block = blockRegistry.register((String)name, () -> type.create(parentBlock));
            CreativeModeTab tab = switch (type) {
                case VariantType.VERTICAL_SLAB -> {
                    if (!isHidden && ModList.get().isLoaded("quark")) {
                        yield CreativeModeTab.f_40749_;
                    }
                    yield null;
                }
                case VariantType.WALL -> {
                    if (!isHidden) {
                        yield CreativeModeTab.f_40750_;
                    }
                    yield null;
                }
                default -> !isHidden ? CreativeModeTab.f_40749_ : null;
            };
            itemRegistry.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
            map.put(type, (RegistryObject<Block>)block);
        }
        return map;
    }

    @FunctionalInterface
    public static interface WoodRegistryCallback<T extends IForgeRegistryEntry<T>> {
        public void accept(RegistryEvent.Register<T> var1, Collection<WoodSetType> var2);
    }

    public static enum VariantType {
        BLOCK(Block::new),
        SLAB(SlabBlock::new),
        VERTICAL_SLAB(VerticalSlabBlock::new),
        WALL(WallBlock::new),
        STAIRS(StairBlock::new);

        private final BiFunction<Supplier<BlockState>, BlockBehaviour.Properties, Block> constructor;

        private VariantType(BiFunction<Supplier<BlockState>, BlockBehaviour.Properties, Block> constructor) {
            this.constructor = constructor;
        }

        private VariantType(Function<BlockBehaviour.Properties, Block> constructor) {
            this.constructor = (b, p) -> (Block)constructor.apply((BlockBehaviour.Properties)p);
        }

        private Block create(Block parent) {
            return this.constructor.apply(() -> ((Block)parent).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent));
        }
    }
}

