/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.villager_ai;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.villager_ai.VillagerBrainEvent;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class VillagerAIManager {
    public static final DeferredRegister<Schedule> SCHEDULES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SCHEDULES, (String)"selene");
    protected static final RegistryObject<Schedule> CUSTOM_VILLAGER_SCHEDULE = SCHEDULES.register("villager_baby_halloween", Schedule::new);
    private static final List<Consumer<VillagerBrainEvent>> LISTENERS = new ArrayList<Consumer<VillagerBrainEvent>>();
    private static Field MEMORIES = null;

    public static void addVillagerAiEventListener(Consumer<VillagerBrainEvent> callback) {
        LISTENERS.add(callback);
    }

    public static void onRegisterBrainGoals(Brain<Villager> brain, AbstractVillager villager) {
        if (villager instanceof Villager) {
            Villager v = (Villager)villager;
            VillagerBrainEvent event = new VillagerBrainEvent(brain, v);
            for (Consumer<VillagerBrainEvent> l : LISTENERS) {
                l.accept(event);
            }
            if (event.hasCustomSchedule()) {
                brain.m_21912_(event.buildFinalizedSchedule());
                brain.m_21862_(villager.f_19853_.m_46468_(), villager.f_19853_.m_46467_());
            }
        }
    }

    public static void init() {
    }

    public static void registerMemory(MemoryModuleType<?> memoryModuleType) {
        try {
            ImmutableList oldValue = Villager.f_35367_;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)oldValue);
            builder.add(memoryModuleType);
            Villager.f_35367_ = builder.build();
        }
        catch (Exception e) {
            Selene.LOGGER.warn("failed to register pumpkin sensor type for villagers: " + e);
        }
    }
}

