/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.structure_gel.api.util.GelCollectors;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;

public class SeaMossPlantBlock
extends BushBlock
implements LiquidBlockContainer,
BonemealableBlock,
IForgeShearable {
    private static final VoxelShape MAIN_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapeUtil.rotate((VoxelShape)NORTH_SHAPE, (Direction)Direction.SOUTH);
    private static final VoxelShape EAST_SHAPE = VoxelShapeUtil.rotate((VoxelShape)NORTH_SHAPE, (Direction)Direction.EAST);
    private static final VoxelShape WEST_SHAPE = VoxelShapeUtil.rotate((VoxelShape)NORTH_SHAPE, (Direction)Direction.WEST);
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    private static final Map<Direction, BooleanProperty> DIRECTION_TO_PROP = GelCollectors.mapOf((Object)Direction.NORTH, (Object)NORTH, (Object[])new Object[]{Direction.SOUTH, SOUTH, Direction.EAST, EAST, Direction.WEST, WEST});
    private static final Map<Direction, VoxelShape> DIRECTION_TO_SHAPE = GelCollectors.mapOf((Object)Direction.NORTH, (Object)NORTH_SHAPE, (Object[])new Object[]{Direction.SOUTH, SOUTH_SHAPE, Direction.EAST, EAST_SHAPE, Direction.WEST, WEST_SHAPE});

    public SeaMossPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = MAIN_SHAPE;
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            if (!((Boolean)state.m_61143_((Property)DIRECTION_TO_PROP.get(dir))).booleanValue()) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DIRECTION_TO_SHAPE.get(dir));
        }
        return shape;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60783_(world, pos, Direction.UP) && !state.m_60713_(Blocks.f_50450_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return fluidState.m_76153_((Tag)FluidTags.f_13131_) && fluidState.m_76186_() == 8 ? this.getStateForPlacement(this.m_49966_(), (LevelAccessor)context.m_43725_(), context.m_8083_()) : null;
    }

    public BlockState getStateForPlacement(BlockState state, LevelAccessor world, BlockPos pos) {
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            BlockPos offsetPos = pos.m_142300_(dir);
            state = (BlockState)state.m_61124_((Property)DIRECTION_TO_PROP.get(dir), (Comparable)Boolean.valueOf(world.m_8055_(offsetPos).m_60783_((BlockGetter)world, offsetPos, dir)));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
        if (newState.m_60734_() == this) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            return this.getStateForPlacement(newState, world, currentPos);
        }
        return newState;
    }

    public FluidState m_5888_(BlockState state) {
        return Fluids.f_76193_.m_76068_(false);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        block0: for (int attempts = rand.nextInt(3) + 7; attempts > 0; --attempts) {
            BlockPos offset = pos.m_142082_(rand.nextInt(7) - 3, 0, rand.nextInt(7) - 3);
            for (int y = -1; y <= 1; ++y) {
                BlockPos upOffset = offset.m_6630_(y);
                BlockState placementState = this.getStateForPlacement(state, (LevelAccessor)world, upOffset);
                if (world.m_8055_(upOffset).m_60734_() != Blocks.f_49990_ || !this.m_7898_(placementState, (LevelReader)world, upOffset)) continue;
                world.m_46597_(upOffset, placementState);
                continue block0;
            }
        }
    }
}

