/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.audio;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.audio.ambient.FadingMusicSound;
import com.legacy.blue_skies.client.audio.ambient.TickableMusicSound;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkiesMusicTicker
implements Tickable {
    private final Random rand = new Random();
    private final Minecraft mc;
    public SoundInstance ambientMusic;
    public SoundInstance bossMusic;
    public SoundInstance dungeonMusic;
    public SoundInstance playingRecord;
    private int timeUntilNextMusic = 100;

    public SkiesMusicTicker(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void m_7673_() {
        if (this.mc.f_91074_ != null && !this.mc.m_91106_().m_120403_(this.playingRecord)) {
            ResourceKey playerDim = this.mc.f_91074_.f_19853_.m_46472_();
            boolean properDimension = playerDim == SkiesDimensions.everbrightKey() || playerDim == SkiesDimensions.everdawnKey();
            boolean inWater = this.mc.f_91074_.m_19941_((Tag)FluidTags.f_13131_);
            SkiesPlayer.ifPresent(this.mc.f_91074_, skyPlayer -> {
                boolean insideDungeon;
                boolean bossActive = skyPlayer.getBossType() != null && this.mc.f_91065_.m_93090_().m_93713_();
                boolean bl = insideDungeon = skyPlayer.getDungeonMusicId() != null && skyPlayer.getDungeonMusicId() != SkiesDungeonType.NONE;
                if (this.dungeonMusic != null && this.dungeonMusic.m_7769_() <= 0.0f) {
                    this.dungeonMusic = null;
                    if (this.ambientMusic != null) {
                        this.timeUntilNextMusic = 1200;
                    }
                }
                if (this.ambientMusic != null && this.ambientMusic.m_7769_() <= 0.0f) {
                    this.ambientMusic = null;
                }
                if (this.bossMusic != null && this.bossMusic.m_7769_() <= 0.0f) {
                    this.bossMusic = null;
                }
                if (bossActive && properDimension) {
                    TrackType bosstrack = this.getBossTrack(skyPlayer.getBossType());
                    if (this.ambientMusic != null || this.dungeonMusic != null) {
                        this.stopMusic();
                        this.stopDungeonMusic();
                    }
                    if (this.bossMusic != null && !this.mc.m_91106_().m_120403_(this.bossMusic)) {
                        this.bossMusic = null;
                        this.timeUntilNextMusic = Math.min(Mth.m_14072_((Random)this.rand, (int)bosstrack.getMinDelay(), (int)bosstrack.getMaxDelay()), this.timeUntilNextMusic);
                    }
                    this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, bosstrack.getMaxDelay());
                    if (this.bossMusic == null && this.timeUntilNextMusic-- <= 0) {
                        this.playBossMusic(bosstrack);
                    }
                } else if (!bossActive && properDimension && this.mc.m_91106_().m_120403_(this.bossMusic)) {
                    this.playBossFanfare(skyPlayer.getBossType());
                } else if (insideDungeon && properDimension) {
                    TrackType tracktype = this.getDungeonTrack(skyPlayer.getDungeonMusicId());
                    if (this.ambientMusic != null) {
                        this.stopMusic();
                    }
                    if (this.dungeonMusic != null && !this.mc.m_91106_().m_120403_(this.dungeonMusic)) {
                        this.dungeonMusic = null;
                        this.timeUntilNextMusic = Math.min(Mth.m_14072_((Random)this.rand, (int)tracktype.getMinDelay(), (int)200), this.timeUntilNextMusic);
                    }
                    if (this.timeUntilNextMusic <= 0 || this.timeUntilNextMusic > 200 && this.ambientMusic == null) {
                        this.timeUntilNextMusic = 0;
                    }
                    if (this.dungeonMusic == null && this.timeUntilNextMusic-- <= 0) {
                        this.playDungeonMusic(tracktype);
                    }
                } else if (properDimension) {
                    TrackType tracktype = this.getRandomAmbientTrack((ResourceKey<Level>)playerDim, inWater);
                    if (this.bossMusic != null || this.dungeonMusic != null) {
                        this.stopBossMusic();
                        this.stopDungeonMusic();
                    }
                    if (this.ambientMusic != null && !this.mc.m_91106_().m_120403_(this.ambientMusic)) {
                        this.ambientMusic = null;
                        this.timeUntilNextMusic = Math.min(Mth.m_14072_((Random)this.rand, (int)tracktype.getMinDelay(), (int)tracktype.getMaxDelay()), this.timeUntilNextMusic);
                    }
                    this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, tracktype.getMaxDelay());
                    if (this.ambientMusic != null && this.ambientMusic.m_7769_() < 1.0f || this.ambientMusic == null && this.timeUntilNextMusic-- <= 0) {
                        this.playMusic(tracktype);
                    }
                }
            });
        } else {
            this.stopMusic();
            this.stopDungeonMusic();
            this.stopBossMusic();
        }
    }

    public boolean playingMusic() {
        return this.ambientMusic != null;
    }

    public boolean playingRecord() {
        return this.playingRecord != null;
    }

    public TrackType getRandomAmbientTrack(ResourceKey<Level> dimType, boolean inWater) {
        if (dimType == SkiesDimensions.everbrightKey()) {
            if (inWater) {
                return TrackType.WHISTLESHELL;
            }
            int num = this.rand.nextInt(5);
            switch (num) {
                case 0: {
                    return TrackType.BRISEGEL;
                }
                case 1: {
                    return TrackType.TURQUOISE;
                }
                case 2: {
                    return TrackType.BRIGHTLANDS;
                }
                case 3: {
                    return TrackType.BRITTLEBUSH;
                }
            }
            return TrackType.SNOWCAP;
        }
        int num = this.rand.nextInt(5);
        switch (num) {
            case 0: {
                return TrackType.MOONLIT_BLOOM;
            }
            case 1: {
                return TrackType.BANEFUL;
            }
            case 2: {
                return TrackType.CRYSTAL_DUNES;
            }
            case 3: {
                return TrackType.GATEKEEPERS_TALE;
            }
        }
        return TrackType.MARS;
    }

    public TrackType getBossTrack(SkiesDungeonType bossType) {
        if (bossType == null) {
            return TrackType.GENERIC_BOSS;
        }
        switch (bossType) {
            case BLINDING: {
                return TrackType.BLINDING_BOSS;
            }
            case NATURE: {
                return TrackType.NATURE_BOSS;
            }
            case POISON: {
                return TrackType.POISON_BOSS;
            }
        }
        return TrackType.GENERIC_BOSS;
    }

    public TrackType getDungeonTrack(SkiesDungeonType dungeonType) {
        switch (dungeonType) {
            case BLINDING: {
                return TrackType.BLINDING_AMBIENCE;
            }
            case NATURE: {
                return TrackType.NATURE_AMBIENCE;
            }
            case POISON: {
                return TrackType.POISON_AMBIENCE;
            }
        }
        return TrackType.BLINDING_AMBIENCE;
    }

    public void playMusic(TrackType requestedMusicType) {
        this.ambientMusic = new FadingMusicSound(requestedMusicType.getMusicLocation(), SoundSource.MUSIC, false);
        ((FadingMusicSound)this.ambientMusic).setVolume(1.0f);
        ((FadingMusicSound)this.ambientMusic).ticksPlayed = 40;
        this.mc.m_91106_().m_120367_(this.ambientMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void playDungeonMusic(TrackType requestedMusicType) {
        this.dungeonMusic = new FadingMusicSound(requestedMusicType.getMusicLocation(), SoundSource.MUSIC, true);
        this.mc.m_91106_().m_120367_(this.dungeonMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void playBossMusic(TrackType requestedMusicType) {
        this.bossMusic = new TickableMusicSound(requestedMusicType.getMusicLocation(), SoundSource.MUSIC, true);
        this.mc.m_91106_().m_120367_(this.bossMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void playBossFanfare(SkiesDungeonType bossType) {
        SoundEvent sound = SoundEvents.f_11689_;
        if (bossType != null) {
            switch (bossType) {
                case BLINDING: {
                    sound = SkiesSounds.MUSIC_BLINDING_DEFEAT;
                    break;
                }
                case NATURE: {
                    sound = SkiesSounds.MUSIC_NATURE_DEFEAT;
                    break;
                }
                case POISON: {
                    sound = SkiesSounds.MUSIC_POISON_DEFEAT;
                    break;
                }
                default: {
                    sound = SkiesSounds.MUSIC_GENERIC_DEFEAT;
                }
            }
        }
        this.stopBossMusic();
        this.timeUntilNextMusic = 200;
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119745_((SoundEvent)sound));
    }

    public void stopBossMusic() {
        if (this.bossMusic != null) {
            this.mc.m_91106_().m_120399_(this.bossMusic);
            this.bossMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    public void stopMusic() {
        if (this.ambientMusic != null) {
            ((FadingMusicSound)this.ambientMusic).shouldNotFade = false;
            this.timeUntilNextMusic = 0;
        }
    }

    public void stopDungeonMusic() {
        if (this.dungeonMusic != null) {
            ((FadingMusicSound)this.dungeonMusic).shouldNotFade = false;
            this.timeUntilNextMusic = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum TrackType {
        MARS(SkiesSounds.MUSIC_MARS, 1200, 1500),
        MOONLIT_BLOOM(SkiesSounds.MUSIC_MOONLIT_BLOOM, 1200, 1500),
        BRISEGEL(SkiesSounds.MUSIC_BRISEGEL, 1200, 1500),
        TURQUOISE(SkiesSounds.MUSIC_TURQUOISE, 1200, 1500),
        SNOWCAP(SkiesSounds.MUSIC_SNOWCAP, 1200, 1500),
        BANEFUL(SkiesSounds.MUSIC_BANEFUL, 1200, 1500),
        BRIGHTLANDS(SkiesSounds.MUSIC_BRIGHTLANDS, 1200, 1500),
        CRYSTAL_DUNES(SkiesSounds.MUSIC_CRYSTAL_DUNES, 1200, 1500),
        GATEKEEPERS_TALE(SkiesSounds.MUSIC_GATEKEEPERS_TALE, 1200, 1500),
        WHISTLESHELL(SkiesSounds.MUSIC_WHISTLESHELL, 1200, 1500),
        BRITTLEBUSH(SkiesSounds.MUSIC_BRITTLEBUSH, 1200, 1500),
        BLINDING_AMBIENCE(SkiesSounds.MUSIC_BLINDING_AMBIENCE, 0, 200),
        NATURE_AMBIENCE(SkiesSounds.MUSIC_NATURE_AMBIENCE, 0, 200),
        POISON_AMBIENCE(SkiesSounds.MUSIC_POISON_AMBIENCE, 0, 200),
        BLINDING_BOSS(SkiesSounds.MUSIC_BLINDING_BOSS, 0, 0),
        NATURE_BOSS(SkiesSounds.MUSIC_NATURE_BOSS, 0, 0),
        POISON_BOSS(SkiesSounds.MUSIC_POISON_BOSS, 0, 0),
        GENERIC_BOSS(SkiesSounds.MUSIC_GENERIC_BOSS, 0, 0),
        LOOP_TEST(SkiesSounds.MUSIC_GENERIC_BOSS, 1200, 1500);

        private final SoundEvent musicLocation;
        private final int minDelay;
        private final int maxDelay;

        private TrackType(SoundEvent musicLocationIn, int minDelayIn, int maxDelayIn) {
            this.musicLocation = musicLocationIn;
            this.minDelay = minDelayIn;
            this.maxDelay = maxDelayIn;
        }

        public SoundEvent getMusicLocation() {
            return this.musicLocation;
        }

        public int getMinDelay() {
            return this.minDelay;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }
    }
}

