/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.assets.BlueSkiesAssets;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalNarratorButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalSectionButton;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.journal.JournalEntry;
import com.legacy.blue_skies.data.objects.journal.JournalRequirement;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class BlueJournalEntryScreen
extends BlueJournalScreen {
    private final JournalEntry entry;
    public final JournalSectionButton sectionButton;
    private List<List<FormattedText>> pagesOfLines = new ArrayList<List<FormattedText>>();
    private JournalEntry.Lore lore;

    public BlueJournalEntryScreen(@Nullable BlueJournalScreen previousScreen, JournalEntry entry, JournalSectionButton sectionButton) {
        super(previousScreen);
        this.entry = entry;
        this.sectionButton = sectionButton;
    }

    @Override
    protected void loadData() {
        this.pagesOfLines.clear();
        int lineWidth = 135;
        this.lore = this.getLore();
        List lines = this.f_96547_.m_92865_().m_92414_((FormattedText)new TextComponent("\n\n").m_7220_((Component)BlueSkiesAssets.JOURNAL_LANG.getTranslation(this.lore.text)), lineWidth, Style.f_131099_);
        int linesPerPage = 16;
        this.totalPages = lines.size() / linesPerPage + (lines.size() % linesPerPage == 0 ? 0 : 1);
        for (int i = 0; i < this.totalPages; ++i) {
            this.pagesOfLines.add(lines.subList(i * linesPerPage, Math.min(linesPerPage * (i + 1), lines.size())));
        }
        if (this.lore.display != null) {
            ++this.totalPages;
            if (this.pagesOfLines.size() >= 1) {
                this.pagesOfLines.add(1, new ArrayList());
            }
            this.lore.display.init(this.f_96541_);
        }
        JournalSectionButton currentSectionButton = new JournalSectionButton(this.f_96543_ / 2 + 145, this.f_96544_ / 2 - 100, this.sectionButton.section, button -> this.previousScreen.goBack());
        currentSectionButton.forced = true;
        this.m_142416_((GuiEventListener)currentSectionButton);
        this.m_142416_((GuiEventListener)new JournalNarratorButton(this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 84, button -> {
            ArrayList<FormattedText> text = new ArrayList<FormattedText>();
            for (List<FormattedText> page : this.pagesOfLines) {
                for (FormattedText line : page) {
                    text.add(line);
                }
            }
            JournalNarratorButton.narrate(Arrays.asList(text));
        }));
    }

    protected JournalEntry.Lore getLore() {
        if (this.entry.lores.size() == 1) {
            return this.entry.lores.get(0);
        }
        this.entry.lores.sort((p1, p2) -> {
            JournalRequirement r1 = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(p1.requirement);
            JournalRequirement r2 = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(p2.requirement);
            if (r1 == null || r2 == null) {
                return 0;
            }
            int a1 = r1.advancement == null ? 0 : 1;
            int a2 = r2.advancement == null ? 0 : 1;
            int b1 = r1.everbrightProgression < 0 ? 0 : r1.everbrightProgression;
            int b2 = r2.everbrightProgression < 0 ? 0 : r2.everbrightProgression;
            int d1 = r1.everdawnProgression < 0 ? 0 : r1.everdawnProgression;
            int d2 = r2.everdawnProgression < 0 ? 0 : r2.everdawnProgression;
            int total1 = a1 + b1 + d1;
            int total2 = a2 + b2 + d2;
            return Integer.compare(total1, total2);
        });
        for (JournalEntry.Lore lorePair : Lists.reverse(this.entry.lores)) {
            if (lorePair.requirement != null) {
                ClientAdvancements advancements;
                Advancement advancement;
                LocalPlayer player = this.f_96541_.f_91074_;
                JournalRequirement requirement = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(lorePair.requirement);
                if (requirement == null) continue;
                boolean advancementDone = false;
                if (requirement.advancement != null && (advancement = (advancements = player.f_108617_.m_105145_()).m_104396_().m_139337_(requirement.advancement)) != null) {
                    advancementDone = ((AdvancementProgress)advancements.f_104390_.get(advancement)).m_8193_();
                }
                int everbrightProg = SkiesPlayer.getIfPresent(player, s -> s.getBrightProgression(), () -> -1);
                int everdawnProg = SkiesPlayer.getIfPresent(player, s -> s.getDawnProgression(), () -> -1);
                if (!advancementDone && requirement.advancement != null || everbrightProg < requirement.everbrightProgression && requirement.everbrightProgression >= 0 || everdawnProg < requirement.everdawnProgression && requirement.everdawnProgression >= 0) continue;
                return lorePair;
            }
            return lorePair;
        }
        return this.entry.lores.get(this.entry.lores.size() - 1);
    }

    @Override
    protected void renderExtra(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.page == 0) {
            this.renderTitle(matrix);
            if (this.lore.display != null) {
                this.renderDisplay(matrix, partialTicks);
            }
        }
        this.renderText(matrix, this.page);
    }

    protected void renderTitle(PoseStack matrix) {
        TextComponent title = BlueSkiesAssets.JOURNAL_LANG.getTranslation(this.entry.title);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.f_96547_.m_92889_(matrix, (Component)title, (float)(centerX - this.f_96547_.m_92852_((FormattedText)title) / 2 - 80), (float)(centerY - 90), 0);
        SkiesClientUtil.bind(BlueJournalScreen.WIDGETS);
        this.m_93228_(matrix, centerX - 140, centerY - 80, 0, 74, 122, 6);
    }

    protected void renderText(PoseStack matrix, int page) {
        int middleX = this.f_96543_ / 2;
        int middleY = this.f_96544_ / 2;
        for (int i = 0; i < 2 && page + i < this.pagesOfLines.size(); ++i) {
            int offset = 0;
            for (FormattedText t : this.pagesOfLines.get(page + i)) {
                this.f_96547_.m_92889_(matrix, (Component)new TextComponent(t.getString()), (float)(middleX + (i == 0 ? -145 : 4)), (float)(middleY - 105 + (offset += 11)), 0);
            }
        }
    }

    protected void renderDisplay(PoseStack matrix, float partialTicks) {
        SkiesClientUtil.bind(BlueJournalScreen.DISPLAY_FRAME);
        int bookHeight = 220;
        this.m_93228_(matrix, this.f_96543_ / 2, (this.f_96544_ - bookHeight) / 2, 0, 0, 153, bookHeight);
        this.lore.display.render(matrix, this.f_96541_, this.f_96543_, this.f_96544_, partialTicks);
    }
}

